/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.cache.FileList;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.source.ProjectFileSource;
import ch.e2e.builder.compiler.build.tasks.source.Source;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.utils.JaxbUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class MultipleOutputsCacheAbleTask
extends CacheAbleTask {
    private FileList resultFileList;

    public MultipleOutputsCacheAbleTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._file_list;
    }

    protected Path getBaseDirectory() {
        return this.getSourceManager().getWorkFolder().toPath();
    }

    protected abstract Set<String> getDestinationFiles();

    @Override
    public boolean isUpToDate() {
        if (!super.isUpToDate()) {
            return false;
        }
        FileList resultFileList = this.getFileList();
        if (!resultFileList.compilerVersion.equals(this.getCompilerVersion()) && !resultFileList.files.isEmpty()) {
            return false;
        }
        return resultFileList.files.keySet().stream().allMatch(destinationFile -> Files.exists(this.getBaseDirectory().resolve((String)destinationFile), new LinkOption[0]));
    }

    private FileList getFileList() {
        if (this.resultFileList == null) {
            try {
                this.resultFileList = JaxbUtils.unmarshalXml(this.getDestinationFile(), FileList.class);
            }
            catch (Exception e) {
                this.resultFileList = new FileList();
            }
        }
        return this.resultFileList;
    }

    private void saveFileList() {
        FileList fileList = new FileList();
        fileList.compilerVersion = this.getCompilerVersion();
        fileList.files.putAll(this.getDestinationFilesHashes());
        JaxbUtils.marshalXml((Object)fileList, this.getDestinationFile());
    }

    private Map<String, String> getDestinationFilesHashes() {
        return this.getDestinationFiles().stream().collect(Collectors.toMap(Function.identity(), this::getDestinationHash));
    }

    private String getDestinationHash(String id) {
        try {
            String hash;
            Source source = this.getSourceManager().getSource(id);
            if (source == null) {
                source = new ProjectFileSource(new File(this.getSourceManager().getWorkFolder(), id));
            }
            return (hash = String.valueOf(source.getHash())).isEmpty() ? "null" : hash;
        }
        catch (Exception e) {
            return "null";
        }
    }

    @Override
    protected void afterExecute() {
        this.saveFileList();
        super.afterExecute();
    }
}

