/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.error.BuilderWarning;
import ch.e2e.builder.compiler.error.DefaultCompilerError;
import ch.e2e.builder.compiler.error.DefaultCompilerWarning;
import com.google.javascript.jscomp.AbstractCommandLineRunner;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.CompilerOptions;
import java.io.File;
import java.util.HashMap;

public class JavaScriptCompiler
extends CommandLineRunner {
    private File jsFile;
    private File source;
    private AbstractErrorHandler errorHandler;

    public AbstractErrorHandler getErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = new AbstractErrorHandler(){};
        }
        return this.errorHandler;
    }

    public JavaScriptCompiler(File jsFile) {
        super(new String[]{"--js=" + jsFile.getAbsolutePath() + ".bak"});
        this.source = new File(jsFile.getAbsolutePath() + ".bak");
        if (!jsFile.renameTo(this.source)) {
            this.getErrorHandler().error((AbstractBuilderError)new DefaultCompilerError("Could not rename " + jsFile.getAbsolutePath(), new HashMap<String, String>()));
        }
        this.jsFile = jsFile;
    }

    public void compile() {
        if (this.source.exists()) {
            try {
                this.doRun();
                if (!this.source.delete()) {
                    this.getErrorHandler().warning((BuilderWarning)new DefaultCompilerWarning("Could not delete " + this.source.getAbsolutePath(), new HashMap<String, String>()));
                }
            }
            catch (AbstractCommandLineRunner.FlagUsageException e) {
                System.err.println(e.getMessage());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected CompilerOptions createOptions() {
        CompilerOptions result = super.createOptions();
        result.jsOutputFile = this.jsFile.getAbsolutePath();
        return result;
    }
}

