/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.build.tasks.Task;
import ch.e2e.builder.compiler.build.tasks.control.CompileControl;
import ch.e2e.builder.compiler.build.types.Deploy;
import ch.e2e.builder.compiler.build.types.HeaderField;
import ch.e2e.builder.compiler.build.types.Parameter;
import ch.e2e.builder.compiler.build.types.Upload;
import ch.e2e.builder.compiler.error.DeployError;
import ch.e2e.builder.compiler.error.DeployErrorHandler;
import ch.e2e.builder.compiler.event.SendMessageEvent;
import ch.e2e.builder.compiler.net.BridgeResultError;
import ch.e2e.builder.compiler.net.BridgeResultParser;
import ch.e2e.builder.compiler.net.MultipartFormRequest;
import ch.e2e.event.EventController;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;

public abstract class DeployTask
extends Task {
    private Deploy deploy;
    private AbstractErrorHandler errorHandler;
    Map<String, String> replaceMap;

    public DeployTask() {
        super(new CompileControl[0]);
    }

    public Map<String, String> getReplaceMap() {
        return this.replaceMap;
    }

    public void setReplaceMap(Map<String, String> replaceMap) {
        this.replaceMap = replaceMap;
    }

    public Deploy getDeploy() {
        return this.deploy;
    }

    public void setDeploy(Deploy deploy) {
        this.deploy = deploy;
    }

    @Override
    public AbstractErrorHandler getErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = new AbstractErrorHandler(new File(this.getDeploy().getErrorHandler().getLogfile().getParentFile(), this.getClass().getSimpleName() + ".errors")){};
        }
        return this.errorHandler;
    }

    @Override
    public String getTaskSourceName() {
        return this.getDeploy().getUploads().get(0).getName();
    }

    @Override
    protected void propagateErrors() {
        this.getErrorHandler().serialize(false);
        if (this.getDeploy() != null) {
            this.getErrorHandler().addTo((AbstractErrorHandler)this.getDeploy().getErrorHandler());
            this.getDeploy().getErrorHandler().serialize(true);
        }
    }

    @Override
    public void executeTask(int dependencyLevel) throws BuildException {
        DeployErrorHandler errorHandler = this.deploy.getErrorHandler();
        SendMessageEvent event = new SendMessageEvent(this, "deploying", this.getReplaceMap());
        EventController.fire((EventObject)((Object)event));
        try {
            MultipartFormRequest request = this.createRequest(this.deploy);
            if (request != null) {
                this.addHeaderFields(request);
                this.uploadFiles(request, errorHandler);
                this.sendParameter(request);
                request.flush();
                this.checkAnswer(request, errorHandler);
            }
        }
        catch (MalformedURLException muEx) {
            DeployError error = new DeployError("error.deploy.malformed.url", this.getReplaceMap());
            errorHandler.error(error);
        }
        catch (UnknownHostException uhEx) {
            this.getReplaceMap().put("host", uhEx.getMessage());
            DeployError error = new DeployError("error.deploy.unknown.host", this.getReplaceMap());
            errorHandler.error(error);
        }
        catch (ConnectException cEx) {
            DeployError error = new DeployError("error.deploy.connect", this.getReplaceMap());
            errorHandler.error(error);
        }
        catch (Exception ex) {
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException(ex);
        }
    }

    protected String getCompilerId() {
        return "";
    }

    protected abstract MultipartFormRequest createRequest(Deploy var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAnswer(MultipartFormRequest request, DeployErrorHandler errorHandler) {
        try {
            DeployError deployError;
            BridgeResultParser resultParser = new BridgeResultParser(request.getAnswer());
            for (BridgeResultError error : resultParser.getErrors()) {
                deployError = this.createError(error);
                errorHandler.error(deployError);
            }
            for (BridgeResultError error : resultParser.getFatalErrors()) {
                deployError = this.createError(error);
                errorHandler.fatalError(this.createError(error));
            }
            for (BridgeResultError warning : resultParser.getWarnings()) {
                deployError = new DeployError(warning.getMessage());
                errorHandler.warning(deployError);
            }
        }
        catch (SocketTimeoutException cEx) {
            DeployError error = new DeployError("error.deploy.timeout", this.getReplaceMap());
            errorHandler.error(error);
        }
        catch (Exception ex) {
            errorHandler.error(new DeployError("error.deploy.unknown.error", this.getReplaceMap()));
            Logging.logger.severe("Caught a " + ex.getClass().getName() + ": " + ex.getMessage());
            Logging.logger.throwing(this.getClass().getName(), "checkAnswer", ex);
        }
        finally {
            request.closeConnection();
        }
    }

    private DeployError createError(BridgeResultError error) {
        DeployError deployError = new DeployError(error.getMessage());
        if (error.getMessage().contains("Permission denied")) {
            this.deploy.getLogin().setPassword(null);
        }
        return deployError;
    }

    private void addHeaderFields(MultipartFormRequest request) {
        ArrayList<HeaderField> headerFields = this.deploy.getHeaderFields();
        for (HeaderField headerField : headerFields) {
            request.addHeaderField(headerField.getName(), headerField.getValue());
        }
    }

    private void uploadFiles(MultipartFormRequest request, DeployErrorHandler errorHandler) throws IOException {
        ArrayList<Upload> uploads = this.deploy.getUploads();
        for (Upload upload : uploads) {
            if (upload.getInputStream() != null) {
                request.sendStream(upload.getName(), upload.getFilename(), upload.getInputStream());
                continue;
            }
            this.getReplaceMap().put("absolute path", upload.getFilename());
            DeployError error = new DeployError("error.deploy.jarfile.notfound", this.getReplaceMap());
            errorHandler.error(error);
        }
    }

    private void sendParameter(MultipartFormRequest request) throws IOException {
        ArrayList<Parameter> parameter = this.deploy.getParameter();
        for (Parameter param : parameter) {
            request.sendParameter(param.getName(), param.getValue());
        }
    }
}

