/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CompilerTask;
import ch.e2e.builder.compiler.build.tasks.control.CompileControl;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.io.FileFilter;

public class CleanTask
extends CompilerTask {
    private static CleanDescriptorFileFilter cleanDescriptorFilter = new CleanDescriptorFileFilter();
    private static CleanDocumentFileFilter cleanDocumentFilter = new CleanDocumentFileFilter();
    private static CleanConfigurationFileFilter cleanConfigurationFilter = new CleanConfigurationFileFilter();

    public CleanTask() {
        super(new CompileControl[0]);
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        UmlDocument umlDocument = this.getUmlDocument();
        if (umlDocument == null) {
            throw new BuildException("UmlDocument not defined for task: " + this.getClass().getSimpleName());
        }
        try {
            FileUtilities.delete((File)umlDocument.getDocumentWorkingFolder(), (FileFilter)cleanConfigurationFilter, (boolean)true);
            FileUtilities.delete((File)umlDocument.getDocumentWorkingFolder(), (FileFilter)cleanDescriptorFilter, (boolean)true);
            FileUtilities.delete((File)umlDocument.getDocumentWorkingFolder(), (FileFilter)cleanDocumentFilter, (boolean)true);
            umlDocument.clearAllErrors();
            this.deleteJavaAndUIFiles(umlDocument);
        }
        catch (Exception ex) {
            this.showFatalError(ex.getMessage() == null ? "null" : ex.getMessage());
            throw new BuildException(ex);
        }
    }

    private void deleteJavaAndUIFiles(UmlDocument umlDocument) {
        File htdocsDir = new File(umlDocument.getDocumentWorkingFolder(), "htdocs/");
        if (htdocsDir.exists()) {
            FileUtilities.silentDeleteDirectory((File)htdocsDir);
        }
        File wrapperFolder = new File(umlDocument.getDocumentWorkingFolder(), "wrapper");
        FileUtilities.silentDeleteAll((File)wrapperFolder);
    }

    private static class CleanDescriptorFileFilter
    implements FileFilter {
        private CleanDescriptorFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".descriptor") || pathname.getName().endsWith("descriptor.xml");
        }
    }

    private static class CleanDocumentFileFilter
    implements FileFilter {
        private CleanDocumentFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".tabfiles") || pathname.getName().endsWith(".bxmi") || pathname.getName().endsWith(".bxmi.wi") || !pathname.getName().endsWith(".exmi.errors") && pathname.getName().endsWith(".errors");
        }
    }

    private static class CleanConfigurationFileFilter
    extends CleanDocumentFileFilter {
        private CleanConfigurationFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return super.accept(pathname) || pathname.getName().endsWith(".deploy") || pathname.getName().endsWith(".wsdl") || pathname.getName().endsWith(".wsdl.template") || pathname.getName().endsWith(".xsd") || pathname.getName().endsWith(".xsd.template") || pathname.getName().endsWith(".asynchronous.trace") || pathname.getName().endsWith("asynchronous.trace") || pathname.getName().endsWith("asynchronous.trace.template") || pathname.getName().endsWith(".tabfiles");
        }
    }
}

