/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.process;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.error.BuilderError;
import ch.e2e.builder.base.error.BuilderFatalError;
import ch.e2e.builder.base.error.BuilderWarning;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.process.Process;
import ch.e2e.builder.compiler.build.tasks.CleanTask;
import ch.e2e.builder.compiler.build.tasks.CreateAsynchronousTraceTask;
import ch.e2e.builder.compiler.build.tasks.DefaultTask;
import ch.e2e.builder.compiler.build.tasks.DeployRepositoryTask;
import ch.e2e.builder.compiler.build.tasks.DeploymentDescriptorTask;
import ch.e2e.builder.compiler.build.tasks.ExmiWithImportTask;
import ch.e2e.builder.compiler.build.tasks.JavaWrapperCompilerTask;
import ch.e2e.builder.compiler.build.tasks.RepositoryTask;
import ch.e2e.builder.compiler.build.tasks.TabfileMergeTask;
import ch.e2e.builder.compiler.build.tasks.Task;
import ch.e2e.builder.compiler.build.tasks.Xmi2DescriptorTask;
import ch.e2e.builder.compiler.build.tasks.Xmi2ExmiTask;
import ch.e2e.builder.compiler.build.tasks.Xmi2TabTask;
import ch.e2e.builder.compiler.build.tasks.control.CompileControl;
import ch.e2e.builder.compiler.build.types.Deploy;
import ch.e2e.builder.compiler.document.IncludesFile;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.event.SendErrorEvent;
import ch.e2e.builder.compiler.event.SendFatalErrorEvent;
import ch.e2e.builder.compiler.event.SendInfoEvent;
import ch.e2e.builder.compiler.event.SendWarningEvent;
import ch.e2e.event.EventController;
import java.io.File;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CompileProcess
extends Process {
    public static final String DEPLOY_REPOSITORY_TASK = "Deploy_Repository_Task";
    public static final String REPOSITORY_TASK = "Repository_Task";
    public static final String ALL_XMI2TAB_TASK = "All_Xmi2Tab_Task";
    public static final String XMI2DESCRIPTOR_TASK = "Xmi2Descriptor_Task";
    public static final String CLEAN_ALL_TASK = "Clean_All_Task";
    private final UmlDocument umlDocument;
    private final String compilableObjectName;
    private boolean isLibrary = false;
    private Deploy deploy;
    private final Map<String, File> repositoryOutputFiles = new HashMap<String, File>();
    private final Map<String, CompileProcess> processes;
    private Set<CompileProcess> dependsOnProcesses;
    private Xmi2ExmiTask xmi2ExmiTask;
    private ExmiWithImportTask exmiWithImportTask;
    private Xmi2DescriptorTask xmi2DescriptorTask;
    private Xmi2TabTask xmi2TabTask;
    private DefaultTask allXmi2TabTask;
    private TabfileMergeTask tabfileMergeTask;
    private DeploymentDescriptorTask deploymentDescriptorTask;
    private CreateAsynchronousTraceTask createAsynchronousTraceTask;
    private JavaWrapperCompilerTask javaWrapperCompilerTask;
    private RepositoryTask repositoryTask;
    private DeployRepositoryTask deployRepositoryTask;
    private CleanTask cleanTask;
    private DefaultTask cleanAllTask;

    public void setRepositoryOutputFile(String compilableObjectName, File repositoryFile) {
        this.repositoryOutputFiles.put(compilableObjectName, repositoryFile);
    }

    private Xmi2ExmiTask getXmi2ExmiTask() {
        if (this.xmi2ExmiTask == null) {
            this.xmi2ExmiTask = new Xmi2ExmiTask();
            this.xmi2ExmiTask.setUmlDocument(this.umlDocument);
        }
        return this.xmi2ExmiTask;
    }

    private ExmiWithImportTask getExmiWithImportTask() {
        if (this.exmiWithImportTask == null) {
            this.exmiWithImportTask = new ExmiWithImportTask();
            this.exmiWithImportTask.setUmlDocument(this.umlDocument);
            this.exmiWithImportTask.addDependsOnTask(this.getXmi2ExmiTask());
            for (CompileProcess process : this.getAllDependsOnProcesses()) {
                this.exmiWithImportTask.addDependsOnTask(process.getXmi2ExmiTask());
            }
        }
        return this.exmiWithImportTask;
    }

    private Xmi2DescriptorTask getXmi2DescriptorTask() {
        if (this.xmi2DescriptorTask == null) {
            this.xmi2DescriptorTask = new Xmi2DescriptorTask();
            this.xmi2DescriptorTask.setUmlDocument(this.umlDocument);
            this.xmi2DescriptorTask.addDependsOnTask(this.getExmiWithImportTask());
        }
        return this.xmi2DescriptorTask;
    }

    private Xmi2TabTask getXmi2TabTask() {
        if (this.xmi2TabTask == null) {
            this.xmi2TabTask = new Xmi2TabTask();
            this.xmi2TabTask.setUmlDocument(this.umlDocument);
            this.xmi2TabTask.addDependsOnTask(this.getExmiWithImportTask());
        }
        return this.xmi2TabTask;
    }

    private DefaultTask getAllXmi2TabTask() {
        if (this.allXmi2TabTask == null) {
            this.allXmi2TabTask = new DefaultTask();
            this.allXmi2TabTask.addDependsOnTask(this.getXmi2TabTask());
            for (CompileProcess process : this.getAllDependsOnProcesses()) {
                this.allXmi2TabTask.addDependsOnTask(process.getXmi2TabTask());
            }
        }
        return this.allXmi2TabTask;
    }

    private TabfileMergeTask getTabfileMergeTask() {
        if (this.tabfileMergeTask == null) {
            this.tabfileMergeTask = new TabfileMergeTask();
            this.tabfileMergeTask.setUmlDocument(this.umlDocument);
            this.tabfileMergeTask.setCompilableObjectName(this.compilableObjectName);
            this.tabfileMergeTask.setLibrary(this.isLibrary);
            this.tabfileMergeTask.addDependsOnTask(this.getXmi2DescriptorTask());
            this.tabfileMergeTask.addDependsOnTask(this.getXmi2TabTask());
            for (CompileProcess process : this.getAllDependsOnProcesses()) {
                this.tabfileMergeTask.addDependsOnTask(process.getXmi2TabTask());
            }
        }
        return this.tabfileMergeTask;
    }

    private DeploymentDescriptorTask getDeploymentDescriptorTask() {
        if (this.deploymentDescriptorTask == null) {
            this.deploymentDescriptorTask = new DeploymentDescriptorTask();
            this.deploymentDescriptorTask.setUmlDocument(this.umlDocument);
            this.deploymentDescriptorTask.setCompilableObjectName(this.compilableObjectName);
            this.deploymentDescriptorTask.setLibrary(this.isLibrary);
            this.deploymentDescriptorTask.addDependsOnTask(this.getTabfileMergeTask());
        }
        return this.deploymentDescriptorTask;
    }

    private CreateAsynchronousTraceTask getCreateAsynchronousTraceTask() {
        if (this.createAsynchronousTraceTask == null) {
            this.createAsynchronousTraceTask = new CreateAsynchronousTraceTask();
            this.createAsynchronousTraceTask.setUmlDocument(this.umlDocument);
            this.createAsynchronousTraceTask.setCompilableObjectName(this.compilableObjectName);
            this.createAsynchronousTraceTask.setLibrary(this.isLibrary);
            this.createAsynchronousTraceTask.addDependsOnTask(this.getXmi2DescriptorTask());
            this.createAsynchronousTraceTask.addDependsOnTask(this.getXmi2TabTask());
            for (CompileProcess process : this.getAllDependsOnProcesses()) {
                this.createAsynchronousTraceTask.addDependsOnTask(process.getXmi2TabTask());
            }
        }
        return this.createAsynchronousTraceTask;
    }

    private JavaWrapperCompilerTask getJavaWrapperCompilerTask() {
        if (this.javaWrapperCompilerTask == null) {
            this.javaWrapperCompilerTask = new JavaWrapperCompilerTask();
            this.javaWrapperCompilerTask.setUmlDocument(this.umlDocument);
            this.javaWrapperCompilerTask.setCompilableObjectName(this.compilableObjectName);
            this.javaWrapperCompilerTask.setLibrary(this.isLibrary);
            this.javaWrapperCompilerTask.addDependsOnTask(this.getXmi2TabTask());
            this.javaWrapperCompilerTask.addDependsOnTask(this.getXmi2DescriptorTask());
            for (CompileProcess process : this.getAllDependsOnProcesses()) {
                this.javaWrapperCompilerTask.addDependsOnTask(process.getXmi2TabTask());
            }
        }
        return this.javaWrapperCompilerTask;
    }

    private RepositoryTask getRepositoryTask() {
        if (this.repositoryTask == null) {
            this.repositoryTask = new RepositoryTask();
            this.repositoryTask.setUmlDocument(this.umlDocument);
            this.repositoryTask.setCompilableObjectName(this.compilableObjectName);
            this.repositoryTask.setLibrary(this.isLibrary);
            for (Map.Entry<String, File> entry : this.repositoryOutputFiles.entrySet()) {
                this.repositoryTask.setDestFile(entry.getKey(), entry.getValue());
            }
            this.repositoryTask.addDependsOnTask(this.getDeploymentDescriptorTask());
            this.repositoryTask.addDependsOnTask(this.getCreateAsynchronousTraceTask());
            this.repositoryTask.addDependsOnTask(this.getJavaWrapperCompilerTask());
        }
        return this.repositoryTask;
    }

    private DeployRepositoryTask getDeployRepositoryTask() {
        if (this.deployRepositoryTask == null) {
            this.deployRepositoryTask = new DeployRepositoryTask(new CompileControl[0]);
            this.deployRepositoryTask.setUmlDocument(this.umlDocument);
            this.deployRepositoryTask.setCompilableObjectName(this.compilableObjectName);
            this.deployRepositoryTask.setLibrary(this.isLibrary);
            this.deployRepositoryTask.setDeploy(this.deploy);
            this.deployRepositoryTask.addDependsOnTask(this.getRepositoryTask());
        }
        return this.deployRepositoryTask;
    }

    private CleanTask getCleanTask() {
        if (this.cleanTask == null) {
            this.cleanTask = new CleanTask();
            this.cleanTask.setUmlDocument(this.umlDocument);
        }
        return this.cleanTask;
    }

    private DefaultTask getCleanAllTask() {
        if (this.cleanAllTask == null) {
            this.cleanAllTask = new DefaultTask();
            this.cleanAllTask.addDependsOnTask(this.getCleanTask());
            for (CompileProcess process : this.getAllDependsOnProcesses()) {
                this.cleanAllTask.addDependsOnTask(process.getCleanTask());
            }
        }
        return this.cleanAllTask;
    }

    public CompileProcess(UmlDocument umlDocument) {
        this(umlDocument, null, new HashMap<String, CompileProcess>());
    }

    public CompileProcess(UmlDocument umlDocument, String compilableObjectName) {
        this(umlDocument, compilableObjectName, new HashMap<String, CompileProcess>());
    }

    public CompileProcess(UmlDocument umlDocument, String compilableObjectName, boolean isLibrary) {
        this(umlDocument, compilableObjectName, new HashMap<String, CompileProcess>());
        this.isLibrary = isLibrary;
    }

    public CompileProcess(UmlDocument umlDocument, String compilableObjectName, Deploy deploy) {
        this(umlDocument, compilableObjectName, new HashMap<String, CompileProcess>());
        this.isLibrary = false;
        this.deploy = deploy;
    }

    public CompileProcess(UmlDocument umlDocument, Map<String, CompileProcess> processes) {
        this(umlDocument, null, processes);
    }

    private CompileProcess(UmlDocument umlDocument, String compilableObjectName, Map<String, CompileProcess> processes) {
        this.umlDocument = umlDocument;
        this.compilableObjectName = compilableObjectName;
        this.processes = processes;
        this.processes.put(umlDocument.getUniqueId(), this);
    }

    @Override
    protected Task getTask(String taskKey) {
        switch (taskKey) {
            case "Deploy_Repository_Task": {
                return this.getDeployRepositoryTask();
            }
            case "Repository_Task": {
                return this.getRepositoryTask();
            }
            case "All_Xmi2Tab_Task": {
                return this.getAllXmi2TabTask();
            }
            case "Xmi2Descriptor_Task": {
                return this.getXmi2DescriptorTask();
            }
            case "Clean_All_Task": {
                return this.getCleanAllTask();
            }
        }
        return null;
    }

    private CompileProcess getProcess(UmlDocument umlDocument) {
        CompileProcess res = this.processes.get(umlDocument.getUniqueId());
        if (res == null) {
            res = new CompileProcess(umlDocument, this.processes);
        }
        return res;
    }

    private Set<CompileProcess> getAllDependsOnProcesses() {
        HashSet<CompileProcess> res = new HashSet<CompileProcess>();
        this.addDependsOnProcesses(res);
        return res;
    }

    private Set<CompileProcess> getDependsOnProcesses() {
        if (this.dependsOnProcesses == null) {
            this.dependsOnProcesses = new HashSet<CompileProcess>();
            try {
                Xmi2ExmiTask xmi2ExmiTask = this.getXmi2ExmiTask();
                xmi2ExmiTask.setUmlDocument(this.umlDocument);
                xmi2ExmiTask.execute();
                for (IncludesFile includesFile : this.umlDocument.getDocumentInfo().getDependsFile().getIncludesFiles().values()) {
                    UmlDocument includedDocument = this.umlDocument.getUmlDocumentFactory().getUmlDocumentById(includesFile.getUmlFileID());
                    if (includedDocument == null) {
                        includedDocument = this.umlDocument.getUmlDocumentFactory().getUmlDocumentByName(includesFile.getFilename());
                    }
                    if (includedDocument == null) continue;
                    CompileProcess process = this.getProcess(includedDocument);
                    this.dependsOnProcesses.add(process);
                }
            }
            catch (BuildException ex) {
                EventController.fire((EventObject)((Object)new SendFatalErrorEvent(this.getSource(), ex.getMessage() == null ? "null" : ex.getMessage())));
            }
        }
        return this.dependsOnProcesses;
    }

    private void addDependsOnProcesses(Set<CompileProcess> dependsOnProcesses) {
        for (CompileProcess process : this.getDependsOnProcesses()) {
            if (!dependsOnProcesses.add(process)) continue;
            process.addDependsOnProcesses(dependsOnProcesses);
        }
    }

    @Override
    protected void sendStartInfoMessage(String taskKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String messageKey = null;
        parameters.put("document.name", this.umlDocument.getName());
        if (this.compilableObjectName != null) {
            parameters.put("composite.name", this.compilableObjectName);
        }
        if (taskKey.equals(ALL_XMI2TAB_TASK)) {
            messageKey = "starting.document.compile";
        } else if (taskKey.equals(REPOSITORY_TASK)) {
            messageKey = this.compilableObjectName != null ? "starting.composite.compile" : "starting.composites.compile";
        } else if (taskKey.equals(DEPLOY_REPOSITORY_TASK)) {
            messageKey = "starting.composite.deployment";
        }
        if (messageKey != null) {
            EventController.fire((EventObject)((Object)new SendInfoEvent(this.getSource(), messageKey, parameters)));
        }
    }

    @Override
    protected int getErrorCount(String taskKey) {
        return this.getTask(taskKey).getErrorHandler().getErrorCount();
    }

    @Override
    protected int getWarningCount(String taskKey) {
        return this.getTask(taskKey).getErrorHandler().getWarningCount();
    }

    private void fireEvents(AbstractErrorHandler errorHandler) {
        for (BuilderWarning warning : errorHandler.getWarnings()) {
            EventController.fire((EventObject)((Object)new SendWarningEvent(this.getSource(), warning)));
        }
        for (BuilderError error : errorHandler.getErrors()) {
            EventController.fire((EventObject)((Object)new SendErrorEvent(this.getSource(), error)));
        }
        for (BuilderError error : errorHandler.getFatalErrors()) {
            EventController.fire((EventObject)((Object)new SendFatalErrorEvent(this.getSource(), (BuilderFatalError)error)));
        }
    }

    @Override
    protected String getBuildTypeMessage(String taskKey) {
        String buildType = super.getBuildTypeMessage(taskKey);
        switch (taskKey) {
            case "Clean_All_Task": {
                buildType = "build.type.clean";
                break;
            }
            case "Xmi2Descriptor_Task": {
                buildType = "build.type.precompilation";
                break;
            }
            case "Repository_Task": 
            case "All_Xmi2Tab_Task": {
                buildType = "build.type.compilation";
                break;
            }
            case "Deploy_Repository_Task": {
                buildType = "build.type.deployment";
            }
        }
        return E2EBuilderTranslator.getModuleTranslation((String)"compiler", (String)buildType, (String)buildType);
    }

    @Override
    protected void buildFinished(String taskKey) {
        this.fireEvents(this.getTask(taskKey).getErrorHandler());
        if (taskKey.equals(XMI2DESCRIPTOR_TASK)) {
            return;
        }
        super.buildFinished(taskKey);
    }
}

