/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.action;

import ch.e2e.builder.compiler.build.BuildProperties;
import ch.e2e.builder.compiler.build.action.DeployBuildAction;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.error.DeployErrorHandler;
import ch.e2e.builder.compiler.net.Login;
import java.io.File;

public class DeployDeploymentBuildAction
extends DeployBuildAction {
    private File repository;

    public DeployDeploymentBuildAction(Deployment deployment, Login login) {
        super(deployment.getCompilableObject(), deployment, login);
        File outputFolder = new File(System.getProperty("ch.e2e.builder.base.repository"));
        UmlDocument umlDocument = deployment.getCompilableObject().getUmlDocument();
        outputFolder = new File(outputFolder, umlDocument.getDocumentName());
        String filename = deployment.getName() + deployment.getCompilableObject().getRepositoryFileExtension();
        this.repository = new File(outputFolder, filename);
    }

    public DeployDeploymentBuildAction(File repository, Login login, boolean startup, boolean override, boolean overrideSettings, DeployErrorHandler errorHandler) {
        super(login, startup, override, overrideSettings, errorHandler);
        this.repository = repository;
        this.setBuildSource(this.simpleName(repository));
    }

    @Override
    public String getAction() {
        return "buildaction.deploy.configuration";
    }

    public File getRepository() {
        return this.repository;
    }

    @Override
    public String getRequestedPage() {
        return BuildProperties.getInstance().getString("deploy.configuration.application.name");
    }

    @Override
    public String getName() {
        return "Deploying " + this.simpleName(this.repository) + " to " + this.getLogin().getUrl();
    }

    private String simpleName(File file) {
        String name = file.getName();
        int endIndex = 0;
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) != '.') continue;
            endIndex = i;
        }
        return name.substring(0, endIndex);
    }
}

