/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build;

import ch.e2e.builder.compiler.build.Logging;
import ch.e2e.builder.compiler.build.UrlService;
import ch.e2e.builder.compiler.tools.TransformerFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class SchemaUrlService
extends UrlService
implements Logging {
    private static String frontendSchema;
    private static String backendSchema;

    public static String getFrontendSchema() {
        return frontendSchema;
    }

    public static String getBackendSchema() {
        return backendSchema;
    }

    private static String createSchemaUrlFromClassPath(String schemaName) {
        URL url = SchemaUrlService.class.getClassLoader().getResource(schemaName);
        if (url == null) {
            throw new RuntimeException("Could not find the schema '" + schemaName + "' in the classpath.");
        }
        String schemaUrl = SchemaUrlService.encodeURL(url);
        return schemaUrl;
    }

    private static String createSchemaUrlFromFileSystem(String schemaName, String schemaPath) {
        String schemaUrl = null;
        File schemaDir = new File(schemaPath);
        File schema = new File(schemaDir, schemaName);
        try {
            schemaUrl = schema.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(SchemaUrlService.class.getName(), "createSchemaUrlFromFileSystem", e);
        }
        return schemaUrl;
    }

    static {
        String schemapath = System.getProperty("ch.e2e.builder.compiler..schemapath");
        String backendSchemaName = TransformerFactory.getInstance().getString("backend.schema");
        String frontendSchemaName = TransformerFactory.getInstance().getString("frontend.schema");
        if (schemapath == null) {
            backendSchema = SchemaUrlService.createSchemaUrlFromClassPath(backendSchemaName);
            frontendSchema = SchemaUrlService.createSchemaUrlFromClassPath(frontendSchemaName);
        } else {
            backendSchema = SchemaUrlService.createSchemaUrlFromFileSystem(backendSchemaName, schemapath);
            frontendSchema = SchemaUrlService.createSchemaUrlFromFileSystem(frontendSchemaName, schemapath);
        }
    }
}

