/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.util;

import ch.e2e.util.TimeoutException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

public class JarExecutor {
    private String jarPath;
    private long defaultTimeout = 60000L;

    public JarExecutor(String jarPath) {
        this.jarPath = jarPath;
    }

    public ProcessResult execute() throws IOException, TimeoutException, InterruptedException {
        return this.execute(new String[0], this.defaultTimeout);
    }

    public ProcessResult execute(long timeout) throws IOException, TimeoutException, InterruptedException {
        return this.execute(new String[0], timeout);
    }

    public ProcessResult execute(String[] args) throws IOException, TimeoutException, InterruptedException {
        return this.execute(args, this.defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessResult execute(String[] args, long timeout) throws IOException, InterruptedException, TimeoutException {
        String javaExecutable = System.getProperty("java.home") + "/bin/java";
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaExecutable);
        command.add("-jar");
        command.add(this.jarPath);
        Collections.addAll(command, args);
        Process process = Runtime.getRuntime().exec(command.toArray(new String[command.size()]));
        BufferedReader output = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        ProcessResult result = new ProcessResult();
        long startTime = System.nanoTime();
        long rem = TimeUnit.MILLISECONDS.toNanos(timeout);
        try {
            while (true) {
                try {
                    result.exitValue = process.exitValue();
                }
                catch (IllegalThreadStateException ex) {
                    if (rem <= 0L) {
                        throw new TimeoutException(timeout);
                    }
                    Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(rem) + 1L, 100L));
                    rem = TimeUnit.MILLISECONDS.toNanos(timeout) - (System.nanoTime() - startTime);
                    continue;
                }
                break;
            }
        }
        finally {
            result.out = this.readBuffer(output);
            result.err = this.readBuffer(error);
        }
        return result;
    }

    private String readBuffer(BufferedReader reader) throws IOException {
        String line;
        StringBuilder res = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            res.append(line).append("\n");
        }
        return res.toString();
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public static class ProcessResult {
        public int exitValue;
        public String out;
        public String err;
    }
}

