/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class FilterFactory {
    public static <T> Iterator<T> newIterator(Iterator<? extends T> iterator, Filter<? super T> filter) {
        return new FilterIterator<T>(iterator, filter);
    }

    public static <T> Iterator<T> newIterator(Iterable<? extends T> iterable, Filter<? super T> filter) {
        return new FilterIterator<T>(iterable.iterator(), filter);
    }

    public static <T> Iterable<T> newIterable(Iterable<? extends T> iterable, Filter<? super T> filter) {
        return new FilteredIterable<T>(iterable, filter);
    }

    private FilterFactory() {
    }

    public static interface Filter<T> {
        public boolean accept(T var1);
    }

    private static class FilterIterator<T>
    implements Iterator<T> {
        private final Iterator<? extends T> iterator;
        private final Filter<? super T> filter;
        private T next;

        public FilterIterator(Iterator<? extends T> iterator, Filter<? super T> filter) {
            this.iterator = iterator;
            this.filter = filter;
            this.next = this.tryGetNext();
        }

        public FilterIterator(Iterable<? extends T> iterable, Filter<? super T> filter) {
            this(iterable.iterator(), filter);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            T result = this.next;
            this.next = this.tryGetNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private T tryGetNext() {
            while (this.iterator.hasNext()) {
                T item = this.iterator.next();
                if (!this.filter.accept(item)) continue;
                return item;
            }
            return null;
        }
    }

    private static class FilteredIterable<T>
    implements Iterable<T> {
        private final Iterable<? extends T> iterable;
        private final Filter<? super T> filter;

        public FilteredIterable(Iterable<? extends T> iterable, Filter<? super T> filter) {
            this.iterable = iterable;
            this.filter = filter;
        }

        @Override
        public Iterator<T> iterator() {
            return new FilterIterator<T>(this.iterable, this.filter);
        }
    }
}

