/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.transaction;

import ch.e2e.transaction.TransactionErrorHandler;
import ch.e2e.transaction.TransactionEvent;
import ch.e2e.transaction.TransactionEventMulticaster;
import ch.e2e.transaction.TransactionException;
import ch.e2e.transaction.TransactionExceptionHandler;
import ch.e2e.transaction.TransactionHandler;
import ch.e2e.transaction.TransactionListener;
import javax.swing.SwingUtilities;

public class TransactionService {
    private static TransactionService service = new TransactionService();
    private TransactionListener listener;
    private Object result;
    private TransactionListener actualListener;
    private TransactionExceptionHandler defaultExceptionHandler;
    private TransactionErrorHandler errorHandler;

    private TransactionService() {
    }

    public static void addTransactionListener(TransactionListener listener) {
        TransactionService.service.listener = TransactionEventMulticaster.addListener(TransactionService.service.listener, listener);
    }

    public static void removeTransactionListener(TransactionListener listener) {
        TransactionService.service.listener = TransactionEventMulticaster.removeListener(TransactionService.service.listener, listener);
    }

    public static void fireTransactionStart(TransactionEvent event) {
        if (TransactionService.service.listener != null) {
            TransactionService.service.listener.transactionStart(event);
        }
    }

    public static void fireTransactionEnd(TransactionEvent event) {
        if (TransactionService.service.listener != null) {
            TransactionService.service.listener.transactionEnd(event);
        }
    }

    public static void fireTransactionFailed(TransactionException exception) {
        if (TransactionService.service.listener != null) {
            TransactionService.service.listener.transactionFailed(exception);
        }
    }

    public static TransactionListener getTransactionListener() {
        return TransactionService.service.listener;
    }

    public static void execute(Object transactionData, TransactionHandler handler, TransactionListener listener) {
        TransactionService.service.actualListener = listener;
        service.fireTransactionStart(handler);
        TransactionService transactionService = service;
        transactionService.getClass();
        Transaction transaction = transactionService.new Transaction(transactionData, handler);
        transaction.start();
    }

    public static void setErrorHandler(TransactionErrorHandler errorHandler) {
        TransactionService.service.errorHandler = errorHandler;
    }

    public static void setDefaultExceptionHandler(TransactionExceptionHandler defaultExceptionHandler) {
        TransactionService.service.defaultExceptionHandler = defaultExceptionHandler;
    }

    private void fireTransactionStart(TransactionHandler handler) {
        TransactionEvent event = new TransactionEvent(handler);
        if (this.actualListener != null) {
            this.actualListener.transactionStart(event);
        }
        if (this.listener != null) {
            this.listener.transactionStart(event);
        }
    }

    private void fireTransactionEnd(TransactionHandler handler) {
        TransactionEvent event = new TransactionEvent(handler, this.result);
        try {
            if (this.actualListener != null) {
                this.actualListener.transactionEnd(event);
            }
            if (this.listener != null) {
                this.listener.transactionEnd(event);
            }
        }
        catch (Throwable t) {
            this.doErrorHandling(new TransactionException(t, handler));
        }
    }

    private void doErrorHandling(TransactionException exception) {
        if (this.errorHandler == null) {
            Throwable t = exception.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
        } else {
            this.errorHandler.transactionError(exception);
        }
    }

    private void fireTransactionException(TransactionException exception) {
        try {
            if (this.actualListener != null) {
                this.actualListener.transactionFailed(exception);
            }
            if (this.listener != null) {
                this.listener.transactionFailed(exception);
            }
            if (!exception.isConsumed() && this.defaultExceptionHandler != null) {
                this.defaultExceptionHandler.transactionFailed(exception);
            }
            if (this.errorHandler != null) {
                this.errorHandler.transactionFailed(exception);
            }
        }
        catch (Throwable t) {
            this.doErrorHandling(exception);
        }
    }

    class TransactionExceptionRunner
    implements Runnable {
        private TransactionException targetException;

        TransactionExceptionRunner(TransactionException targetException) {
            this.targetException = targetException;
        }

        @Override
        public void run() {
            TransactionService.this.fireTransactionException(this.targetException);
        }
    }

    class TransactionEventRunner
    implements Runnable {
        private TransactionHandler handler;

        private TransactionEventRunner(TransactionHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            TransactionService.this.fireTransactionEnd(this.handler);
        }
    }

    class Transaction
    extends Thread {
        private Object transactionData;
        private TransactionHandler handler;

        Transaction(Object transactionData, TransactionHandler handler) {
            this.transactionData = transactionData;
            this.handler = handler;
        }

        @Override
        public final void run() {
            try {
                TransactionService.this.result = this.handler.doTransaction(this.transactionData);
                SwingUtilities.invokeLater(new TransactionEventRunner(this.handler));
            }
            catch (Throwable throwable) {
                TransactionException exception = new TransactionException(throwable, this.handler);
                SwingUtilities.invokeLater(new TransactionExceptionRunner(exception));
            }
        }
    }
}

