/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.net;

import ch.e2e.net.FileObject;
import ch.e2e.net.FileServerConstants;
import ch.e2e.net.FileServerOutput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileServerInputStream
implements FileServerConstants {
    private InputStream in;
    private FileServerOutput output;

    public FileServerInputStream(InputStream in, FileServerOutput logger) throws IOException {
        this.in = in;
        this.output = logger;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public Object readObject() throws IOException {
        Object result = null;
        String line = this.readProtocolLine();
        if (line == null) {
            result = null;
        } else if (line.equals("[FILENAME]")) {
            result = this.readFile();
        } else if (line.equals("[STRING]")) {
            result = this.readString();
        }
        return result;
    }

    public void setOutput(FileServerOutput output) {
        this.output = output;
    }

    private Object readFile() throws IOException {
        String line;
        FileObject result = null;
        String filename = this.readProtocolLine();
        if (this.output != null) {
            this.output.transferStart(filename);
        }
        if ((line = this.readProtocolLine()).equals("[CONTENT-LENGTH]")) {
            line = this.readProtocolLine();
            int contentLength = Integer.parseInt(line);
            if (this.output != null) {
                this.output.log("Content length: " + line);
            }
            ByteArrayOutputStream out = this.readData(contentLength);
            result = new FileObject(filename, out.toByteArray());
            if (this.output != null) {
                this.output.transferEnd(filename);
            }
        } else {
            throw new IOException("Wrong protocol.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayOutputStream readData(int contentLength) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(contentLength);
        byte[] buffer = new byte[4096];
        boolean dataMissing = true;
        int readBytes = 0;
        while (dataMissing) {
            InputStream inputStream = this.in;
            synchronized (inputStream) {
                ByteArrayOutputStream byteArrayOutputStream = out;
                synchronized (byteArrayOutputStream) {
                    int bytes2Read;
                    int rest = contentLength - readBytes;
                    int n = bytes2Read = rest < 4096 ? rest : 4096;
                    if (this.output != null) {
                        this.output.log("reading " + bytes2Read + " bytes");
                    }
                    int amountRead = this.in.read(buffer);
                    out.write(buffer, 0, amountRead);
                    readBytes += amountRead;
                    if (this.output != null) {
                        this.output.log(readBytes + " bytes of " + contentLength + " read");
                    }
                    dataMissing = readBytes < contentLength;
                }
            }
        }
        return out;
    }

    private String readString() throws IOException {
        String line = this.readProtocolLine();
        String result = null;
        if (!line.equals("[CONTENT-LENGTH]")) {
            throw new IOException("Wrong protocol.");
        }
        line = this.readProtocolLine();
        int contentLength = Integer.parseInt(line);
        ByteArrayOutputStream out = this.readData(contentLength);
        result = new String(out.toByteArray());
        return result;
    }

    String readProtocolLine() throws IOException {
        String result = null;
        char c = (char)this.in.read();
        if (c != '\uffff') {
            StringBuffer line = new StringBuffer();
            while (c != '\n' && c != '\uffff') {
                line.append(c);
                c = (char)this.in.read();
            }
            result = line.toString();
        }
        return result;
    }
}

