/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.logging;

import ch.e2e.io.OutputDestination;
import ch.e2e.io.SystemErrRedirector;
import ch.e2e.io.SystemOutRedirector;
import ch.e2e.logging.MaxLinesDocumentFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class LoggingCanvas
extends JPanel
implements OutputDestination {
    private static final int MAX_LINES = 1000;
    private static HashMap<Integer, Style> styles = new HashMap();
    private static Style def;
    private static Style systemErr;
    private static Style systemOut;
    private JTextPane textPane;
    private Style style = def;
    private String lastSearch;
    private int lastIndex;
    private StyleContext context = this.initStylesForTextPane();

    public LoggingCanvas() {
        DefaultStyledDocument doc = new DefaultStyledDocument(this.context);
        doc.setDocumentFilter(new MaxLinesDocumentFilter(1000));
        this.textPane = new JTextPane(doc);
        this.setLayout(new BorderLayout());
        this.add((Component)this.textPane, "Center");
        SystemOutRedirector.getInstance().addOutputDestination(new SystemOut());
        SystemErrRedirector.getInstance().addOutputDestination(new SystemErr());
    }

    public void setColor(Level level, Color color) {
        String name = level.getName();
        int intLevel = level.intValue();
        Style style = this.getStyle(intLevel, name);
        StyleConstants.setForeground(style, color);
    }

    private Style getStyle(int intLevel, String name) {
        Style style = styles.get(intLevel);
        if (style == null) {
            style = this.createStyle(name, this.getDefaultColor(intLevel));
            styles.put(intLevel, style);
        }
        return style;
    }

    public void config(String message) {
        this.appendString(message, this.getStyle(Level.CONFIG.intValue(), Level.CONFIG.getName()));
    }

    public void fine(String message) {
        this.appendString(message, this.getStyle(Level.FINE.intValue(), Level.FINE.getName()));
    }

    public void finer(String message) {
        this.appendString(message, this.getStyle(Level.FINER.intValue(), Level.FINER.getName()));
    }

    public void finest(String message) {
        this.appendString(message, this.getStyle(Level.FINEST.intValue(), Level.FINEST.getName()));
    }

    public void info(String message) {
        this.appendString(message, this.getStyle(Level.INFO.intValue(), Level.INFO.getName()));
    }

    public void severe(String message) {
        this.appendString(message, this.getStyle(Level.SEVERE.intValue(), Level.SEVERE.getName()));
    }

    public void warning(String message) {
        this.appendString(message, this.getStyle(Level.WARNING.intValue(), Level.WARNING.getName()));
    }

    public void setSystemOutEnabled(boolean enabled) {
        if (enabled) {
            SystemOutRedirector.getInstance().setEnabled(true);
            SystemOutRedirector.getInstance().setOriginalStreamEnabled(true);
        }
    }

    public void setSystemErrEnabled(boolean enabled) {
        if (enabled) {
            SystemErrRedirector.getInstance().setEnabled(true);
            SystemErrRedirector.getInstance().setOriginalStreamEnabled(true);
        }
    }

    @Override
    public void requestFocus() {
        this.textPane.requestFocus();
    }

    private void appendString(final String message, final Style style) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    LoggingCanvas.this.textPane.getDocument().insertString(-1, message, style);
                }
                catch (BadLocationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
    }

    private StyleContext initStylesForTextPane() {
        this.context = new StyleContext();
        def = this.context.getStyle("default");
        StyleConstants.setFontFamily(def, "SansSerif");
        StyleConstants.setFontSize(def, 12);
        StyleConstants.setForeground(def, new Color(0, 0, 0));
        systemOut = this.context.addStyle(LoggingCanvas.class.getName() + "systemOut", def);
        StyleConstants.setAlignment(systemOut, 0);
        systemErr = this.context.addStyle(LoggingCanvas.class.getName() + "systemErr", def);
        StyleConstants.setForeground(systemErr, Color.red);
        return this.context;
    }

    private Style createStyle(String name, Color defaultColor) {
        Style style = this.context.addStyle(LoggingCanvas.class.getName() + name, def);
        StyleConstants.setForeground(style, defaultColor);
        return style;
    }

    private Color getDefaultColor(int level) {
        Color defaultColor;
        switch (level) {
            case 1000: {
                defaultColor = new Color(255, 0, 0);
                break;
            }
            case 900: {
                defaultColor = new Color(255, 187, 0);
                break;
            }
            case 800: {
                defaultColor = new Color(0, 0, 0);
                break;
            }
            case 700: {
                defaultColor = new Color(0, 187, 0);
                break;
            }
            case 500: {
                defaultColor = new Color(0, 0, 170);
                break;
            }
            case 400: {
                defaultColor = new Color(0, 0, 204);
                break;
            }
            case 300: {
                defaultColor = new Color(0, 0, 255);
                break;
            }
            case 790: {
                defaultColor = new Color(204, 32, 224);
                break;
            }
            default: {
                defaultColor = new Color(0, 0, 0);
            }
        }
        return defaultColor;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    @Override
    public void println() {
        this.println("");
    }

    @Override
    public void println(String message) {
        this.appendString(message + "\n", this.style);
    }

    @Override
    public void print(String message) {
        this.appendString(message, this.style);
    }

    public void clear() {
        this.textPane.setText("");
        this.textPane.select(0, 0);
    }

    public void find(String textToFind) {
        this.lastSearch = textToFind;
        Document doc = this.textPane.getDocument();
        try {
            int index = doc.getText(0, doc.getLength()).indexOf(textToFind);
            if (index != -1) {
                this.lastIndex = index;
                this.textPane.select(index, index + textToFind.length());
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void findAgain() {
        if (this.lastSearch != null) {
            Document doc = this.textPane.getDocument();
            try {
                int index = doc.getText(0, doc.getLength()).indexOf(this.lastSearch, this.lastIndex + 1);
                if (index != -1) {
                    this.lastIndex = index;
                    this.textPane.select(index, index + this.lastSearch.length());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private class SystemErr
    implements OutputDestination {
        private SystemErr() {
        }

        @Override
        public void println() {
            LoggingCanvas.this.appendString("\n", systemErr);
        }

        @Override
        public void println(String outString) {
            LoggingCanvas.this.appendString(outString + "\n", systemErr);
        }

        @Override
        public void print(String outString) {
            LoggingCanvas.this.appendString(outString, systemErr);
        }
    }

    private class SystemOut
    implements OutputDestination {
        private SystemOut() {
        }

        @Override
        public void println() {
            LoggingCanvas.this.appendString("\n", systemOut);
        }

        @Override
        public void println(String outString) {
            LoggingCanvas.this.appendString(outString + "\n", systemOut);
        }

        @Override
        public void print(String outString) {
            LoggingCanvas.this.appendString(outString, systemOut);
        }
    }
}

