/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.io;

import ch.e2e.io.OutputDestination;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class StreamRedirector
extends PrintStream {
    private Vector<OutputDestination> outputDestinations = new Vector();

    public StreamRedirector(OutputStream stream) {
        super(stream);
    }

    public void addOutputDestination(OutputDestination outputDest) {
        this.outputDestinations.addElement(outputDest);
    }

    public void removeOutputDestination(OutputDestination outputDest) {
        this.outputDestinations.removeElement(outputDest);
    }

    @Override
    public void write(byte[] bytes) {
        this.print(new String(bytes));
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        this.print(new String(bytes, off, len));
    }

    @Override
    public void write(int c) {
        this.print(new String(new char[]{(char)c}));
    }

    @Override
    public void print(String str) {
        this.printOut(this.getOutString(str));
    }

    @Override
    public void print(Object obj) {
        this.printOut(this.getOutString(obj));
    }

    @Override
    public void print(char c) {
        this.printOut(String.valueOf(c));
    }

    @Override
    public void print(char[] cArray) {
        if (cArray == null) {
            this.printOut("null");
        } else {
            this.printOut(new String(cArray));
        }
    }

    @Override
    public void print(boolean b) {
        this.printOut(String.valueOf(b));
    }

    @Override
    public void print(int i) {
        this.printOut(String.valueOf(i));
    }

    public void print(byte b) {
        this.printOut(String.valueOf(b));
    }

    public void print(short s) {
        this.printOut(String.valueOf(s));
    }

    @Override
    public void print(long l) {
        this.printOut(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.printOut(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.printOut(String.valueOf(d));
    }

    @Override
    public void println() {
        this.printlnOut("");
    }

    @Override
    public void println(Object obj) {
        this.printlnOut(this.getOutString(obj));
    }

    @Override
    public void println(String str) {
        this.printlnOut(this.getOutString(str));
    }

    @Override
    public void println(char c) {
        this.printlnOut(String.valueOf(c));
    }

    @Override
    public void println(char[] cArray) {
        this.printlnOut(this.getOutString(cArray));
    }

    @Override
    public void println(boolean b) {
        this.printlnOut(String.valueOf(b));
    }

    @Override
    public void println(int i) {
        this.printlnOut(String.valueOf(i));
    }

    public void println(byte b) {
        this.printlnOut(String.valueOf(b));
    }

    public void println(short s) {
        this.printlnOut(String.valueOf(s));
    }

    @Override
    public void println(long l) {
        this.printlnOut(String.valueOf(l));
    }

    @Override
    public void println(float f) {
        this.printlnOut(String.valueOf(f));
    }

    @Override
    public void println(double d) {
        this.printlnOut(String.valueOf(d));
    }

    protected void printOut(String outString) {
        for (OutputDestination destination : this.outputDestinations) {
            destination.print(outString);
        }
    }

    private void printlnOut(String outString) {
        this.printOut(outString + "\n");
    }

    private String getOutString(Object in) {
        if (in == null) {
            return "null";
        }
        return String.valueOf(in);
    }

    @Override
    public void close() {
        super.close();
        for (OutputDestination destination : this.outputDestinations) {
            if (!(destination instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)destination)).close();
            }
            catch (IOException iOException) {}
        }
    }
}

