/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.functors;

import ch.e2e.functors.Transformer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class InvokerTransformer<T, R>
implements Transformer<T, R> {
    private final String methodName;
    private final Class<?>[] types;
    private final Object[] args;

    public InvokerTransformer(String methodName, Class<?>[] types, Object[] args) {
        this.methodName = methodName;
        this.types = types;
        this.args = args;
    }

    public InvokerTransformer(String methodName) {
        this(methodName, null, null);
    }

    public static <T, R> InvokerTransformer<T, R> newTransformer(String methodName, Class<?>[] types, Object[] arguments) {
        if (methodName == null) {
            throw new IllegalArgumentException("Argument 'methodName' must not be null");
        }
        if (types == null && arguments != null || types != null && arguments == null || types != null && arguments != null && types.length != arguments.length) {
            throw new IllegalArgumentException("The argument 'types' has to match the argument 'arguments'");
        }
        return new InvokerTransformer<T, R>(methodName, types, arguments);
    }

    public static <T, R> InvokerTransformer<T, R> newTransformer(String methodName) {
        return InvokerTransformer.newTransformer(methodName, null, null);
    }

    @Override
    public R transform(T object) {
        Object result = null;
        if (object != null) {
            Class<?> clazz = object.getClass();
            try {
                Method method = clazz.getMethod(this.methodName, this.types);
                result = method.invoke(object, this.args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return (R)result;
    }
}

