/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.dom;

import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BridgeNamespaceContext
implements NamespaceContext {
    public static final String NAMESPACE_URI_SOAP_ENCODING = "http://schemas.xmlsoap.org/soap/encoding/";
    public static final String NAMESPACE_URI_SOAP_ENVELOPE = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String NAMESPACE_URI_SOAP12_ENCODING = "http://www.w3.org/2003/05/soap-encoding";
    public static final String NAMESPACE_URI_SOAP12_ENVELOPE = "http://www.w3.org/2003/05/soap-envelope";
    public static final String DEFAULT_URI = "default";
    private HashMap<String, String> prefix2uri = new HashMap();
    private HashMap<String, String> uri2prefix = new HashMap();

    public BridgeNamespaceContext(Node ... nodes) {
        this.prefix2uri.put("xmlns", "http://www.w3.org/2000/xmlns/");
        for (Node node : nodes) {
            this.addNamespaces(node);
        }
    }

    public void addNamespaces(Node element) {
        if (element.hasAttributes()) {
            NamedNodeMap attributes = element.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                String name = attribute.getNodeName();
                if (!name.startsWith("xmlns")) continue;
                String prefix = attribute.getNodeValue();
                String string = name = name.length() > 6 ? name.substring(6) : DEFAULT_URI;
                if (this.prefix2uri.get(name) != null) continue;
                this.addNamespace(name, prefix);
            }
        }
    }

    public void addNamespace(String prefix, String namespace) {
        this.prefix2uri.put(prefix, namespace);
        this.uri2prefix.put(namespace, prefix);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        String namespaceURI = this.prefix2uri.get(prefix);
        return namespaceURI == null ? "" : namespaceURI;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.uri2prefix.get(namespaceURI);
    }

    public Iterator getPrefixes(String namespaceURI) {
        return null;
    }

    public String getSoapEncodingPrefix() {
        String prefix = this.uri2prefix.get(NAMESPACE_URI_SOAP12_ENCODING);
        return prefix == null ? this.uri2prefix.get(NAMESPACE_URI_SOAP_ENCODING) : prefix;
    }

    public String getSoapEnvelopePrefix() {
        String prefix = this.uri2prefix.get(NAMESPACE_URI_SOAP12_ENVELOPE);
        return prefix == null ? this.uri2prefix.get(NAMESPACE_URI_SOAP_ENVELOPE) : prefix;
    }
}

