/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.tree;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.event.TestcaseRunFinishedEvent;
import ch.e2e.builder.trace.tree.RefreshSynchronousTreeEvent;
import ch.e2e.event.EventController;
import ch.e2e.io.FilesNotDeletedException;
import ch.e2e.util.StringTools;
import java.io.File;
import java.util.EventObject;

public class ClearTestcaseExecuter {
    private E2EBuilderModule module;

    public ClearTestcaseExecuter(E2EBuilderModule module) {
        this.module = module;
    }

    public void clearTestcase(AbstractSynchronousTestcase testcase) {
        FilesNotDeletedException ex = null;
        try {
            testcase.clearResult();
        }
        catch (FilesNotDeletedException e) {
            ex = e;
        }
        this.module.clearMessageView();
        EventController.fire((EventObject)new TestcaseRunFinishedEvent((Object)this, 0));
        EventController.fire((EventObject)new RefreshSynchronousTreeEvent(this, (TestcaseObject)testcase));
        if (ex != null) {
            for (File file : ex.getFiles()) {
                String msg = this.module.getTranslation("could.not.delete." + (file.isDirectory() ? "directory" : "file"));
                this.module.showError(StringTools.replaceProperty((String)msg, (String)"file", (String)file.getPath()));
            }
        }
    }
}

