/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.watch;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.ModulePopupMenu;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.testcase.ViewTestcaseParameterAction;
import ch.e2e.builder.trace.gui.watch.WatchTreeModel;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseParameter;
import ch.e2e.builder.trace.testcase.TestcaseWatch;
import ch.e2e.builder.trace.testcase.parameter.ParameterTransferHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class WatchPopup
extends ModulePopupMenu {
    private JMenuItem showItem;
    private JMenuItem copyItem;
    private JMenuItem deleteItem;
    private TreePath treePath;
    private Testcase testcase;
    private WatchTreeModel treeModel;
    private JPopupMenu.Separator separator;
    private ParameterTransferHandler transferHandler;
    private ViewTestcaseParameterAction showValueAction;

    public WatchPopup(WatchTreeModel treeModel, E2EBuilderModule module) {
        super(module);
        this.treeModel = treeModel;
        this.transferHandler = new ParameterTransferHandler();
        this.addItems();
    }

    public void setTreePath(TreePath treePath, Testcase testcase) {
        boolean visible;
        this.testcase = testcase;
        this.treePath = treePath;
        if (treePath == null) {
            visible = false;
            this.deleteItem.setVisible(false);
        } else {
            TestcaseParameter watch = (TestcaseParameter)treePath.getLastPathComponent();
            this.showValueAction.setParameter(watch);
            this.transferHandler.setParameter(watch);
            this.deleteItem.setVisible(treePath.getPathCount() == 2);
            visible = watch.getType() != 10009 && watch.getType() != 10004;
        }
        this.copyItem.setVisible(visible);
        this.showItem.setVisible(visible);
        this.separator.setVisible(visible || this.deleteItem.isVisible());
    }

    private void addItems() {
        this.deleteItem = ComponentFactory.createMenuItem((String)"popup.testcase.watch.delete", (E2EBuilderModule)this.getModule());
        this.add(this.deleteItem);
        this.deleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WatchPopup.this.deleteWatch();
            }
        });
        this.copyItem = ComponentFactory.createMenuItem((String)"popup.testcase.watch.value.copy", (E2EBuilderModule)this.getModule());
        String text = this.copyItem.getText();
        this.copyItem.setTransferHandler((TransferHandler)this.transferHandler);
        this.copyItem.setAction(TransferHandler.getCopyAction());
        this.copyItem.setText(text);
        this.add(this.copyItem);
        this.showItem = ComponentFactory.createMenuItem((String)"popup.testcase.watch.value.show", (E2EBuilderModule)this.getModule());
        this.showValueAction = new ViewTestcaseParameterAction(this.getModule());
        this.showItem.setAction(this.showValueAction);
        this.add(this.showItem);
        this.separator = new JPopupMenu.Separator();
        this.add(this.separator);
        JMenuItem clearItem = ComponentFactory.createMenuItem((String)"popup.testcase.watch.clear", (E2EBuilderModule)this.getModule());
        clearItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WatchPopup.this.clearView();
            }
        });
        this.add(clearItem);
    }

    private void clearView() {
        this.testcase.removeAllWatches();
        this.treeModel.refresh();
    }

    private void deleteWatch() {
        TestcaseWatch watch = (TestcaseWatch)this.treePath.getLastPathComponent();
        int index = this.testcase.indexOfWatch(watch);
        this.testcase.removeWatch(watch);
        this.treeModel.nodeRemoved(this.treePath.getParentPath(), index, watch);
    }
}

