/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.activity;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.event.OpenLinkEvent;
import ch.e2e.builder.trace.gui.event.SelectInTreeEvent;
import ch.e2e.builder.trace.gui.uml.AbstractCellAction;
import ch.e2e.builder.trace.gui.uml.CellWithContextMenu;
import ch.e2e.builder.trace.gui.uml.ContextMenu;
import ch.e2e.builder.trace.gui.uml.UmlCell;
import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.event.EventController;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import java.util.Map;

public class ThrowCell
extends UmlCell
implements CellWithContextMenu {
    private static ThrowContextMenu contextMenu;
    private String messageId = null;
    private E2EBuilderModule module;

    public ThrowCell(Object userObject, E2EBuilderModule module) {
        super(userObject);
        UmlObject o;
        this.module = module;
        this.initialize();
        if (userObject instanceof UmlObject && (o = (UmlObject)userObject).getChildCount() > 0) {
            this.messageId = ((UmlObject)o.getChild(0)).getName();
        }
    }

    @Override
    public E2EBuilderModule getModule() {
        return this.module;
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    public ThrowContextMenu getContextMenu() {
        if (contextMenu == null) {
            contextMenu = new ThrowContextMenu(this);
        }
        contextMenu.setCell(this);
        return contextMenu;
    }

    public AbstractCellAction<ThrowCell> getDefaultAction() {
        return this.getContextMenu().getDefaultAction();
    }

    @Override
    public boolean isContextMenuAlwaysTriggered() {
        return false;
    }

    private void initialize() {
        UmlGraphConstants.setShowStereotype((Map)this.getAttributes(), false);
    }

    private static class ThrowContextMenu
    extends ContextMenu<ThrowCell> {
        public ThrowContextMenu(ThrowCell cell) {
            super(cell);
            this.createMenu();
        }

        @Override
        public void setCell(ThrowCell cell) {
            super.setCell(cell);
            if (cell.messageId != null) {
                this.setDefaultItem(this.getTranslation("uml.diagram.action.show.message"));
            } else {
                this.setDefaultItem(this.getTranslation("uml.diagram.action.show.in.tree"));
            }
            this.setItemEnabled(this.getTranslation("uml.diagram.action.show.message"), cell.messageId != null);
        }

        private void createMenu() {
            this.addDefaultItem(new AbstractCellAction<ThrowCell>(this.getTranslation("uml.diagram.action.show.in.tree")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object o = ((ThrowCell)this.getCell()).getUserObject();
                    if (o instanceof UmlObject) {
                        EventController.fire((EventObject)new SelectInTreeEvent(this.getCell(), (UmlObject)o));
                    }
                }
            }, ACCELERATOR_SHOW_IN_TREE);
            this.addItem(new AbstractCellAction<ThrowCell>(this.getTranslation("uml.diagram.action.show.message")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String messageId = ((ThrowCell)this.getCell()).messageId;
                    if (messageId != null) {
                        EventController.fire((EventObject)new OpenLinkEvent(this, "file:///addToWatches?entry=" + messageId));
                    }
                }
            });
        }
    }
}

