/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.activity;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.event.OpenLinkEvent;
import ch.e2e.builder.trace.gui.event.SelectInTreeEvent;
import ch.e2e.builder.trace.gui.uml.AbstractCellAction;
import ch.e2e.builder.trace.gui.uml.CellWithContextMenu;
import ch.e2e.builder.trace.gui.uml.ContextMenu;
import ch.e2e.builder.trace.gui.uml.UmlCell;
import ch.e2e.builder.trace.testcase.uml.Action;
import ch.e2e.builder.trace.testcase.uml.Message;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.event.EventController;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.EventObject;

public class SignalCell
extends UmlCell
implements CellWithContextMenu {
    public static final int X_ARROW = 15;
    private static SignalContextMenu contextMenu;
    private Action.Type type;
    private E2EBuilderModule module;

    public SignalCell(Object userObject, E2EBuilderModule module) {
        super(userObject);
        this.module = module;
        this.setType();
    }

    @Override
    public E2EBuilderModule getModule() {
        return this.module;
    }

    public Action.Type getType() {
        return this.type;
    }

    public void setType() {
        this.type = this.userObject instanceof Action ? ((Action)this.userObject).getActionType() : Action.Type.UNKNOWN;
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    public SignalContextMenu getContextMenu() {
        if (contextMenu == null) {
            contextMenu = new SignalContextMenu(this);
        }
        contextMenu.setCell(this);
        return contextMenu;
    }

    public AbstractCellAction<SignalCell> getDefaultAction() {
        return this.getContextMenu().getDefaultAction();
    }

    @Override
    public boolean isContextMenuAlwaysTriggered() {
        return false;
    }

    private static class SignalContextMenu
    extends ContextMenu<SignalCell> {
        public SignalContextMenu(SignalCell cell) {
            super(cell);
            this.createMenu();
        }

        @Override
        public void setCell(SignalCell cell) {
            super.setCell(cell);
            this.setItemVisible(this.getTranslation("uml.diagram.action.show.error"), cell.userObject instanceof UmlObject && ((UmlObject)cell.userObject).hasErrors());
        }

        private void createMenu() {
            this.addDefaultItem(new AbstractCellAction<SignalCell>(this.getTranslation("uml.diagram.action.show.in.tree")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object o = ((SignalCell)this.getCell()).getUserObject();
                    if (o instanceof UmlObject) {
                        EventController.fire((EventObject)new SelectInTreeEvent(this.getCell(), (UmlObject)o));
                    }
                }
            }, ACCELERATOR_SHOW_IN_TREE);
            this.addItem(new AbstractCellAction<SignalCell>(this.getTranslation("uml.diagram.action.show.error")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UmlObject o;
                    if (((SignalCell)this.getCell()).userObject instanceof UmlObject && (o = (UmlObject)((SignalCell)this.getCell()).userObject).hasErrors()) {
                        for (int i = 0; i < o.getChildCount(); ++i) {
                            Object child = o.getChild(i);
                            if (!(child instanceof Message)) continue;
                            EventController.fire((EventObject)new OpenLinkEvent(this.getCell(), "file:///addToWatches?entry=" + ((Message)child).getName()));
                            break;
                        }
                    }
                }
            });
        }
    }
}

