/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.activity;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.event.OpenLinkEvent;
import ch.e2e.builder.trace.gui.uml.AbstractCellAction;
import ch.e2e.builder.trace.gui.uml.CellWithContextMenu;
import ch.e2e.builder.trace.gui.uml.ContextMenu;
import ch.e2e.builder.trace.gui.uml.UmlEdge;
import ch.e2e.builder.trace.testcase.uml.Adapter;
import ch.e2e.builder.trace.testcase.uml.AdapterIO;
import ch.e2e.builder.trace.testcase.uml.Data;
import ch.e2e.builder.trace.testcase.uml.DataContainer;
import ch.e2e.builder.trace.testcase.uml.GenericFlow;
import ch.e2e.builder.trace.testcase.uml.Script;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.event.EventController;
import ch.e2e.swing.MouseOverList;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JMenu;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ActivityEdge
extends UmlEdge
implements CellWithContextMenu {
    private static EdgeContextMenu contextMenu;
    private AdapterIOModel adapterIOModel;

    public ActivityEdge(Object userObject, E2EBuilderModule module) {
        this(userObject, null, module);
    }

    public ActivityEdge(Object userObject, String label, E2EBuilderModule module) {
        super(userObject, label, module);
        this.initializeAdapterIO();
    }

    private void initializeAdapterIO() {
        this.adapterIOModel = new AdapterIOModel();
        if (this.userObject instanceof Adapter) {
            Adapter adapter = (Adapter)this.userObject;
            int nChildren = adapter.getChildCount();
            for (int i = 0; i < nChildren; ++i) {
                int j;
                int n;
                if (!(adapter.getChild(i) instanceof AdapterIO)) continue;
                AdapterIO adapterIO = (AdapterIO)adapter.getChild(i);
                DataContainer container = adapterIO.getInput();
                if (container != null) {
                    n = container.getChildCount();
                    for (j = 0; j < n; ++j) {
                        this.adapterIOModel.add((Data)container.getChild(j));
                    }
                }
                if ((container = adapterIO.getOutput()) == null) continue;
                n = container.getChildCount();
                for (j = 0; j < n; ++j) {
                    this.adapterIOModel.add((Data)container.getChild(j));
                }
            }
        }
    }

    @Override
    public Cursor getCursor() {
        if (this.userObject instanceof Script || this.userObject instanceof GenericFlow || this.userObject instanceof Adapter) {
            return Cursor.getPredefinedCursor(12);
        }
        return null;
    }

    public EdgeContextMenu getContextMenu() {
        if (contextMenu == null) {
            contextMenu = new EdgeContextMenu(this);
        }
        contextMenu.setCell(this);
        return contextMenu;
    }

    public AbstractCellAction<ActivityEdge> getDefaultAction() {
        return this.getContextMenu().getDefaultAction();
    }

    @Override
    public boolean isContextMenuAlwaysTriggered() {
        return false;
    }

    private static class AdapterIOModel
    extends ArrayList<Data>
    implements ListModel {
        private AdapterIOModel() {
        }

        @Override
        public int getSize() {
            return this.size();
        }

        public Object getElementAt(int index) {
            return this.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }

    private static class EdgeContextMenu
    extends ContextMenu<ActivityEdge> {
        private MouseOverList adapterIOList;

        public EdgeContextMenu(ActivityEdge cell) {
            super(cell);
            this.createMenu();
        }

        @Override
        public void setCell(ActivityEdge cell) {
            super.setCell(cell);
            this.adapterIOList.setModel((ListModel)cell.adapterIOModel);
            if (cell.userObject instanceof Script) {
                this.setDefaultItem(this.getTranslation("uml.diagram.action.show.action.script"));
            } else if (cell.userObject instanceof GenericFlow) {
                this.setDefaultItem(this.getTranslation("uml.diagram.action.show.activity"));
            }
            this.setItemVisible(this.getTranslation("uml.diagram.action.show.action.script"), cell.getUserObject() instanceof Script);
            this.setItemVisible(this.getTranslation("uml.diagram.action.show.activity"), cell.getUserObject() instanceof GenericFlow);
            String name = this.getTranslation("uml.diagram.action.show.adapterIO");
            this.setItemVisible(name, cell.userObject instanceof Adapter);
            this.setItemEnabled(name, cell.userObject instanceof Adapter && !cell.adapterIOModel.isEmpty());
        }

        private void createMenu() {
            this.addItem(new AbstractCellAction<ActivityEdge>(this.getTranslation("uml.diagram.action.show.action.script")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object script = ((ActivityEdge)this.getCell()).getUserObject();
                    if (script instanceof Script) {
                        EventController.fire((EventObject)new OpenLinkEvent(this, "file:///showScript?script=" + ((Script)script).getIoId()));
                    }
                }
            });
            this.addItem(new AbstractCellAction<ActivityEdge>(this.getTranslation("uml.diagram.action.show.activity")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventController.fire((EventObject)new OpenLinkEvent(this, "file:///openActivity?activity=" + ((UmlObject)((ActivityEdge)this.getCell()).getUserObject()).getOriginalName()));
                }
            });
            this.adapterIOList = new MouseOverList((ListModel)((ActivityEdge)this.getCell()).adapterIOModel);
            this.adapterIOList.setSelectionMode(0);
            this.adapterIOList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    Data data = (Data)adapterIOList.getSelectedValue();
                    if (data != null) {
                        EventController.fire((EventObject)new OpenLinkEvent(this, "file:///addToWatches?entry=" + data.getValue()));
                        this.setVisible(false);
                        adapterIOList.clearSelection();
                    }
                }
            });
            JMenu adapterIOMenu = new JMenu(this.getTranslation("uml.diagram.action.show.adapterIO"));
            adapterIOMenu.add((Component)this.adapterIOList);
            this.add(adapterIOMenu);
        }
    }
}

