/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml;

import ch.e2e.builder.base.gui.ModulePopupMenu;
import ch.e2e.builder.base.module.E2EBuilderModule;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.jgraph.graph.GraphConstants;

public class UmlGraphConstants
extends GraphConstants {
    public static final Color DARK_GRAY = new Color(0xBBBBBB);
    public static final Color GRAY = new Color(0xDDDDDD);
    public static final Color LIGHT_GRAY = new Color(0xEEEEEE);
    public static final Color GREEN = new Color(13171400);
    public static final Color ORANGE = new Color(0xFF9900);
    public static final String SHOW_SCRIPT_URI = "file:///showScript?script=";
    public static final String OPEN_ACTIVITY_URI = "file:///openActivity?activity=";
    public static final String ADD_TO_WATCHES_URI = "file:///addToWatches?entry=";
    public static final String OPEN_STATE_URI = "file:///openState?state=";
    public static final Color WARNING_COLOR = Color.YELLOW;
    public static final Color ERROR_COLOR = new Color(16744562);
    public static final Color CAUGHT_ERROR_COLOR = new Color(16763256);
    public static final Color NO_TRACE_COLOR = Color.LIGHT_GRAY;
    public static final Color GENERATED_ACTIVITY_COLOR = Color.LIGHT_GRAY;
    public static final Color MOCK_ADAPTER_COLOR = Color.WHITE;
    public static final int INITIAL_NODE_WIDTH = 24;
    public static final int FINAL_NODE_WIDTH = 24;
    public static final double ACTION_WIDTH = 210.0;
    public static final double ACTION_HEIGHT = 60.0;
    public static final Color ACTION_COLOR = new Color(14934976);
    public static final double EXPANSION_REGION_WIDTH = 290.0;
    public static final double EXPANSION_REGION_HEIGHT = 130.0;
    public static final Color EXPANSION_REGION_COLOR = new Color(14934976);
    public static final double DATA_WIDTH = 160.0;
    public static final double DATA_HEIGHT = 20.0;
    public static final Color DATA_COLOR = new Color(0xCCCCFF);
    public static final double DECISION_WIDTH = 50.0;
    public static final Color THROW_COLOR = new Color(16737095);
    public static final double REFERENCE_PIN_WIDTH = 20.0;
    public static final double STATE_WIDTH = 120.0;
    public static final double STATE_HEIGHT = 50.0;
    public static final Color STATE_COLOR = new Color(16645564);
    public static final Color STATE_GRADIENT_COLOR = new Color(0xFDFDFB);
    public static final String GUILLEMOT_OPEN = "\u00ab";
    public static final String GUILLEMOT_CLOSE = "\u00bb";
    public static final int CORNER_RADIUS = 25;
    public static final float[] DASH_PATTERN = new float[]{10.0f, 10.0f};
    public static final Stroke DASHED_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, DASH_PATTERN, 0.0f);
    public static Stroke SELECTION_STROKE = new BasicStroke(5.0f, 0, 0, 10.0f, dash, 0.0f);
    public static final String STEREOTYPE = "stereotype";
    public static final String SHOW_STEREOTYPE = "showStereotype";
    public static final String RUNTIME = "runtime";
    public static final String ROUNED_CORNERS = "roundedCorners";
    public static final String DASHED_BORDER = "dashedBorder";
    public static final String STEREOTYPE_VERTICAL_ALIGNMENT = "stereotypeVerticalAlignment";
    public static final String STEREOTYPE_HORIZONTAL_ALIGNMENT = "stereotypeHorizontalAlignment";
    public static final String STEREOTYPE_VERTICAL_TEXT_POSITION = "stereotypeVerticalTextPosition";
    public static final String STEREOTYPE_HORIZONTAL_TEXT_POSITION = "stereotypeHorizontalTextPosition";
    public static final String TOOL_TIP_TEXT = "toolTipText";
    public static final String ICON_POSITION = "iconPosition";

    public static JPopupMenu newScrolledPopup(JComponent view, E2EBuilderModule module) {
        ModulePopupMenu popup = new ModulePopupMenu(module);
        JScrollPane pane = new JScrollPane(view, 20, 30);
        pane.setBorder(null);
        popup.add(pane);
        return popup;
    }

    public static String getStereotype(Map map) {
        return (String)map.get(STEREOTYPE);
    }

    public static void setStereotype(Map map, String stereotype) {
        if (stereotype == null) {
            map.remove(STEREOTYPE);
        } else {
            map.put(STEREOTYPE, stereotype);
        }
    }

    public static boolean getShowStereotype(Map map) {
        Boolean value = (Boolean)map.get(SHOW_STEREOTYPE);
        return value != null && value != false;
    }

    public static void setShowStereotype(Map map, boolean value) {
        map.put(SHOW_STEREOTYPE, value);
    }

    public static Long getRuntime(Map map) {
        return (Long)map.get(RUNTIME);
    }

    public static void setRuntime(Map map, Long runtime) {
        if (runtime == null) {
            map.remove(RUNTIME);
        } else {
            map.put(RUNTIME, runtime);
        }
    }

    public static boolean getRoundedCorners(Map map) {
        Boolean value = (Boolean)map.get(ROUNED_CORNERS);
        return value != null && value != false;
    }

    public static void setRoundedCorners(Map map, boolean value) {
        map.put(ROUNED_CORNERS, value);
    }

    public static boolean getDashedBorder(Map map) {
        Boolean value = (Boolean)map.get(DASHED_BORDER);
        return value != null && value != false;
    }

    public static void setDashedBorder(Map map, boolean value) {
        map.put(DASHED_BORDER, value);
    }

    public static String getToolTipText(Map map) {
        return (String)map.get(TOOL_TIP_TEXT);
    }

    public static void setToolTipText(Map map, String toolTipText) {
        map.put(TOOL_TIP_TEXT, toolTipText);
    }

    public static IconPosition getIconPosition(Map map) {
        IconPosition position = (IconPosition)((Object)map.get(ICON_POSITION));
        return position == null ? IconPosition.TOP_RIGHT : position;
    }

    public static void setIconPosition(Map map, IconPosition position) {
        map.put(ICON_POSITION, position);
    }

    public static void setIcon(Map map, Icon icon, IconPosition position) {
        UmlGraphConstants.setIcon((Map)map, (Icon)icon);
        UmlGraphConstants.setIconPosition(map, position);
    }

    public static int getStereotypeVerticalAlignment(Map map) {
        Integer alignment = (Integer)map.get(STEREOTYPE_VERTICAL_ALIGNMENT);
        return alignment == null ? 0 : alignment;
    }

    public static void setStereotypeVerticalAlignment(Map map, int alignment) {
        map.put(STEREOTYPE_VERTICAL_ALIGNMENT, alignment);
    }

    public static int getStereotypeHorizontalAlignment(Map map) {
        Integer alignment = (Integer)map.get(STEREOTYPE_HORIZONTAL_ALIGNMENT);
        return alignment == null ? 0 : alignment;
    }

    public static void setStereotypeHorizontalAlignment(Map map, int alignment) {
        map.put(STEREOTYPE_HORIZONTAL_ALIGNMENT, alignment);
    }

    public static void setStereotypeVerticalTextPosition(Map map, int textPosition) {
        map.put(STEREOTYPE_VERTICAL_TEXT_POSITION, textPosition);
    }

    public static int getStereotypeVerticalTextPosition(Map map) {
        Integer textPosition = (Integer)map.get(STEREOTYPE_VERTICAL_TEXT_POSITION);
        return textPosition == null ? 3 : textPosition;
    }

    public static void setStereotypeHorizontalTextPosition(Map map, int textPosition) {
        map.put(STEREOTYPE_HORIZONTAL_TEXT_POSITION, textPosition);
    }

    public static int getStereotypeHorizontalTextPosition(Map map) {
        Integer textPosition = (Integer)map.get(STEREOTYPE_HORIZONTAL_TEXT_POSITION);
        return textPosition == null ? 0 : textPosition;
    }

    private UmlGraphConstants() {
    }

    public static enum IconPosition {
        TOP_LEFT,
        TOP_RIGHT,
        CENTER_LEFT,
        CENTER_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

