/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.tree;

import ch.e2e.builder.trace.testcase.TestcaseParameter;
import ch.e2e.resource.Properties;
import ch.e2e.swing.renderer.EditorContainer;
import ch.e2e.swing.renderer.RendererPreferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ParameterRenderer
extends JPanel
implements EditorContainer {
    protected Color unselectedBackground;
    protected Color selectedBackground;
    protected Color selectedForeground;
    private Color nameColor;
    private Color typeColor;
    private Color diagramColor;
    private Color unselectedForeground;
    private JLabel iconLabel;
    private JLabel nameLabel;
    private JLabel typeLabel;
    private JLabel equalsLabel;
    private JLabel diagramLabel;
    private JLabel colonLabel;
    private RendererPreferences preferences;
    protected JPanel labelPanel;

    public ParameterRenderer(RendererPreferences preferences) {
        super(new BorderLayout());
        this.preferences = preferences;
        this.createGui(preferences.getProperties());
    }

    protected JLabel getIconLabel() {
        return this.iconLabel;
    }

    protected JLabel getNameLabel() {
        return this.nameLabel;
    }

    protected JLabel getTypeLabel() {
        return this.typeLabel;
    }

    protected JLabel getEqualsLabel() {
        return this.equalsLabel;
    }

    protected JLabel getDiagramLabel() {
        return this.diagramLabel;
    }

    protected JLabel getColonLabel() {
        return this.colonLabel;
    }

    public void addEditor(Component editorComponent) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.labelPanel.add(editorComponent, c);
    }

    public void removeEditor(Component editorComponent) {
        this.labelPanel.remove(editorComponent);
    }

    public Component getContainerComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        if (value instanceof TestcaseParameter) {
            int type = this.preferences.getType(value);
            TestcaseParameter parameter = (TestcaseParameter)value;
            this.setLabelVisibility(parameter);
            this.setIcon(type, leaf, expanded, selected);
            this.setUnselectedColors();
        }
        return this;
    }

    protected void setLabelVisibility(TestcaseParameter parameter) {
        if (parameter.isArrayItem() || parameter.isEllipsis()) {
            this.nameLabel.setText("");
            this.colonLabel.setVisible(false);
        } else {
            this.nameLabel.setText(parameter.getName());
            this.colonLabel.setVisible(true);
        }
        this.typeLabel.setText(parameter.getTypeName());
        if (parameter.hasItems() || parameter.isComplex() || parameter.isEllipsis()) {
            this.equalsLabel.setVisible(false);
        } else {
            this.equalsLabel.setVisible(true);
        }
        if (parameter.getDiagramName() == null) {
            this.diagramLabel.setText("");
        } else {
            this.diagramLabel.setText('(' + parameter.getDiagramName() + ')');
        }
    }

    protected void setIcon(int type, boolean leaf, boolean expanded, boolean selected) {
        Icon[] icons = this.preferences.getIcons(type, leaf, expanded, selected);
        if (icons[0] != null) {
            this.iconLabel.setIcon(icons[0]);
            this.iconLabel.setDisabledIcon(icons[1]);
        }
    }

    protected void setSelectedColors() {
        this.labelPanel.setBackground(this.selectedBackground);
        this.nameLabel.setBackground(this.selectedBackground);
        this.nameLabel.setForeground(this.selectedForeground);
        this.typeLabel.setBackground(this.selectedBackground);
        this.typeLabel.setForeground(this.selectedForeground);
        this.equalsLabel.setBackground(this.selectedBackground);
        this.equalsLabel.setForeground(this.selectedForeground);
        this.colonLabel.setForeground(this.selectedForeground);
        this.colonLabel.setBackground(this.selectedBackground);
        this.diagramLabel.setForeground(this.selectedForeground);
        this.diagramLabel.setBackground(this.selectedBackground);
    }

    protected void setUnselectedColors() {
        this.labelPanel.setBackground(this.unselectedBackground);
        this.nameLabel.setBackground(this.unselectedBackground);
        this.colonLabel.setBackground(this.unselectedBackground);
        this.typeLabel.setBackground(this.unselectedBackground);
        this.diagramLabel.setBackground(this.unselectedBackground);
        this.equalsLabel.setBackground(this.unselectedBackground);
        this.nameLabel.setForeground(this.nameColor);
        this.colonLabel.setForeground(this.unselectedForeground);
        this.typeLabel.setForeground(this.typeColor);
        this.diagramLabel.setForeground(this.diagramColor);
        this.equalsLabel.setForeground(this.unselectedForeground);
    }

    protected JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setOpaque(true);
        return label;
    }

    private void createGui(Properties properties) {
        this.unselectedForeground = UIManager.getColor("Tree.textForeground");
        this.unselectedBackground = UIManager.getColor("Tree.textBackground");
        this.selectedForeground = UIManager.getColor("Tree.selectionForeground");
        this.selectedBackground = UIManager.getColor("Tree.selectionBackground");
        this.nameColor = properties.getColor("watches.name.color", Color.BLACK);
        this.typeColor = properties.getColor("watches.type.color", Color.BLACK);
        this.diagramColor = properties.getColor("watches.diagram.color", Color.BLACK);
        this.setBackground(this.unselectedBackground);
        this.setOpaque(true);
        this.labelPanel = new JPanel(new GridBagLayout());
        this.labelPanel.setOpaque(true);
        this.iconLabel = this.createLabel("");
        this.iconLabel.setBackground(Color.WHITE);
        this.iconLabel.setBorder(new EmptyBorder(0, 0, 0, 3));
        this.nameLabel = this.createLabel("");
        this.colonLabel = this.createLabel(": ");
        this.typeLabel = this.createLabel("");
        this.diagramLabel = this.createLabel("");
        this.equalsLabel = this.createLabel(" = ");
        this.add((Component)this.iconLabel, "West");
        this.labelPanel.add(this.nameLabel);
        this.labelPanel.add(this.colonLabel);
        this.labelPanel.add(this.typeLabel);
        this.labelPanel.add(this.diagramLabel);
        this.labelPanel.add(this.equalsLabel);
        this.add((Component)this.labelPanel, "Center");
    }
}

