/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.tree;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.ModulePopupMenu;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.testcase.TestcaseTransferable;
import ch.e2e.builder.trace.gui.tree.TestcaseTreeEvent;
import ch.e2e.builder.trace.gui.tree.TestcaseTreeListener;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.AbstractTestcaseFolder;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;

public class OperationPopupMenu
extends ModulePopupMenu {
    private AbstractTestcaseFolder testcaseFolder;
    private AbstractSynchronousTestcase clipboardTestcase;
    private final JMenuItem paste;
    private TreePath path;

    public OperationPopupMenu(E2EBuilderModule module, final TestcaseTreeListener listener) {
        super(module);
        JMenuItem create = ComponentFactory.createMenuItem((String)"tree.operation.popup.menu.create", (E2EBuilderModule)module);
        create.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.createTestcase(new TestcaseTreeEvent((Object)OperationPopupMenu.this, OperationPopupMenu.this.testcaseFolder));
            }
        });
        this.add(create);
        this.paste = ComponentFactory.createMenuItem((String)"tree.operation.popup.menu.paste", (E2EBuilderModule)module);
        this.paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OperationPopupMenu.this.clipboardTestcase != null) {
                    listener.copyTestcase(new TestcaseTreeEvent((Object)OperationPopupMenu.this, OperationPopupMenu.this.clipboardTestcase, OperationPopupMenu.this.testcaseFolder));
                }
            }
        });
        this.add(this.paste);
    }

    public TreePath getPath() {
        return this.path;
    }

    public void setPath(TreePath path) {
        this.path = path;
        this.testcaseFolder = (AbstractTestcaseFolder)path.getLastPathComponent();
        this.clipboardTestcase = this.getTestcaseFromClipboard();
        this.paste.setEnabled(this.clipboardTestcase != null);
    }

    private AbstractSynchronousTestcase getTestcaseFromClipboard() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        if (clipboard != null) {
            try {
                return (AbstractSynchronousTestcase)clipboard.getData(TestcaseTransferable.testcaseFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

