/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.BlobViewerDialog;
import ch.e2e.builder.trace.gui.DateViewerDialog;
import ch.e2e.builder.trace.gui.TextViewerDialog;
import ch.e2e.builder.trace.gui.watch.WatchPane;
import ch.e2e.builder.trace.testcase.TestcaseParameter;
import ch.e2e.swing.ModalDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class ViewTestcaseParameterAction
extends AbstractAction {
    private static final String ACTION_NAME = "testcase.parameter.value.show";
    private final E2EBuilderModule module;
    private TestcaseParameter parameter;

    public ViewTestcaseParameterAction(E2EBuilderModule module) {
        super(module.getTranslation(ACTION_NAME));
        this.module = module;
    }

    public void setParameter(TestcaseParameter parameter) {
        this.parameter = parameter;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.parameter != null) {
            if (this.parameter.isBlob()) {
                BlobViewerDialog.getDialog(this.module).show((byte[])this.parameter.getValue());
            } else if (this.parameter.isDateTime()) {
                DateViewerDialog.getDialog(this.module).show(this.parameter.getValueAsString());
            } else if (this.parameter.isSimpleType()) {
                TextViewerDialog.getDialog(this.module).showText(this.parameter.getValueAsString(), this.parameter.isTruncated());
            } else {
                ModalDialog dialog = new ModalDialog(E2EBuilder.getInstance().getParentFrame(), 0);
                dialog.add((Component)new WatchPane(this.module, (Dialog)dialog, this.parameter));
                dialog.showDialog();
            }
        }
    }
}

