/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import ch.e2e.builder.base.application.E2EBuilderTransaction;
import ch.e2e.builder.base.application.abstracts.DoTransactionEvent;
import ch.e2e.builder.trace.E2ETraceModule;
import ch.e2e.builder.trace.gui.testcase.LogFileView;
import ch.e2e.builder.trace.gui.testcase.MainPanelView;
import ch.e2e.builder.trace.gui.testcase.RequestLogFileView;
import ch.e2e.builder.trace.gui.testcase.ResponseLogFileView;
import ch.e2e.builder.trace.gui.testcase.TabbedView;
import ch.e2e.builder.trace.gui.testcase.UmlTabbedView;
import ch.e2e.builder.trace.testcase.LogFile;
import ch.e2e.builder.trace.testcase.RequestLogFile;
import ch.e2e.builder.trace.testcase.ResponseLogFile;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.event.TestcaseRunFinishedEvent;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;

public abstract class TestcaseView
extends MainPanelView
implements ChangeListener,
EventExecuter {
    protected JideTabbedPane tabs;
    protected UmlTabbedView uml;
    private LogFileView requestLog;
    private LogFileView responseLog;
    protected TabbedView selectedView;
    private Object root;
    private E2ETraceModule module;

    public TestcaseView(E2ETraceModule module) {
        this.module = module;
        this.createGui(module);
        this.tabs.addChangeListener((ChangeListener)this);
        EventController.register((EventExecuter)this, TestcaseRunFinishedEvent.class);
    }

    public E2ETraceModule getModule() {
        return this.module;
    }

    public UmlTabbedView getUmlView() {
        return this.uml;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.tabs.setEnabled(enabled);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setSelectedView((TabbedView)((Object)this.tabs.getSelectedComponent()));
    }

    public void execute(EventObject event) {
        this.removeLogViews();
    }

    @Override
    public void refresh() {
        ((TabbedView)((Object)this.tabs.getSelectedComponent())).refresh();
    }

    @Override
    public Object getPrintableObject() {
        Component component;
        Object result = null;
        if (this.tabs != null && (component = this.tabs.getSelectedComponent()) != null && component instanceof TabbedView) {
            result = ((TabbedView)((Object)component)).getPrintableObject();
        }
        return result;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(Object root) {
        if (this.root == null || !this.root.equals(root)) {
            this.root = root;
            Testcase testcase = this.findTestcase(root);
            this.setSelectedTestcase(testcase);
            TabbedView newSelectedView = null;
            if (root instanceof RequestLogFile) {
                if (this.tabs.indexOfComponent((Component)this.requestLog) == -1) {
                    this.tabs.addTab(this.module.getTranslation("testcase.view.request.log.panel.name"), (Component)this.requestLog);
                }
                newSelectedView = this.requestLog;
            } else if (root instanceof ResponseLogFile) {
                if (this.tabs.indexOfComponent((Component)this.responseLog) == -1) {
                    this.tabs.addTab(this.module.getTranslation("testcase.view.response.log.panel.name"), (Component)this.responseLog);
                }
                newSelectedView = this.responseLog;
            } else if (root instanceof Testcase) {
                newSelectedView = this.setNewTestcase((Testcase)root);
            } else if (root instanceof TreePath) {
                newSelectedView = this.selectedView != null && this.selectedView.equals(this.uml) ? this.uml : (TabbedView)((Object)this.tabs.getComponentAt(0));
            }
            if (newSelectedView != null) {
                newSelectedView.setRoot(root);
                this.setSelectedView(newSelectedView);
            }
        }
    }

    private TabbedView setNewTestcase(Testcase testcase) {
        TabbedView selectedView;
        if (testcase.getStatus() == 7) {
            selectedView = (TabbedView)((Object)this.tabs.getComponentAt(0));
            this.removeLogViews();
        } else {
            if (testcase.getUmlTree() == null) {
                EventController.fire((EventObject)new DoTransactionEvent((Object)this, (E2EBuilderTransaction)new LoadUmlTreeTransaction(), (Object)testcase));
            }
            selectedView = (TabbedView)((Object)this.tabs.getSelectedComponent());
        }
        return selectedView;
    }

    protected void removeLogViews() {
        this.tabs.remove((Component)this.responseLog);
        this.tabs.remove((Component)this.requestLog);
    }

    private Testcase findTestcase(Object selectedObject) {
        Testcase testcase = null;
        if (selectedObject instanceof LogFile) {
            testcase = (Testcase)((LogFile)selectedObject).getParent();
        } else if (selectedObject instanceof TreePath) {
            Object[] pathObjects = ((TreePath)selectedObject).getPath();
            for (int i = 0; i < pathObjects.length && testcase == null; ++i) {
                if (!(pathObjects[i] instanceof Testcase)) continue;
                testcase = (Testcase)pathObjects[i];
            }
        } else if (selectedObject instanceof Testcase) {
            testcase = (Testcase)selectedObject;
        }
        return testcase;
    }

    protected void setSelectedTestcase(Testcase testcase) {
        this.uml.setTestcase(testcase);
        this.requestLog.setTestcase(testcase);
        this.responseLog.setTestcase(testcase);
    }

    private void createGui(E2ETraceModule module) {
        this.setLayout(new BorderLayout());
        this.tabs = new JideTabbedPane(){

            public void processMouseSelection(int i, MouseEvent mouseEvent) {
                super.processMouseSelection(i, mouseEvent);
            }
        };
        this.tabs.setShowCloseButtonOnTab(true);
        this.uml = new UmlTabbedView(module);
        this.tabs.addTab(module.getTranslation("testcase.view.uml.panel.name"), (Component)((Object)this.uml));
        this.tabs.setTabClosableAt(0, false);
        this.requestLog = new RequestLogFileView();
        this.responseLog = new ResponseLogFileView();
        this.add((Component)this.tabs, "Center");
    }

    private void setSelectedView(TabbedView selectedView) {
        if (this.selectedView == null || !this.selectedView.equals(selectedView)) {
            if (this.selectedView != null) {
                this.selectedView.setSelected(false);
            }
            this.selectedView = selectedView;
            if (selectedView.equals(this.uml) && this.root instanceof TreePath) {
                this.uml.setRoot(this.root);
            }
        }
        this.setViewVisible(selectedView);
        this.selectedView.setSelected(true);
    }

    protected void setViewVisible(TabbedView view) {
        this.uml.setVisible(view == this.uml);
        this.requestLog.setVisible(view == this.requestLog);
        this.responseLog.setVisible(view == this.responseLog);
        this.tabs.setSelectedComponent((Component)((Object)view));
    }

    private static class LoadUmlTreeTransaction
    extends E2EBuilderTransaction {
        private LoadUmlTreeTransaction() {
            super(false);
        }

        public Object doTransaction(Object transactionData) throws Throwable {
            return ((Testcase)transactionData).loadUmlTreeFromDisk();
        }

        public void prepareTransaction() {
        }

        public void setTransactionResult(Object transactionResult) {
        }

        public String getDescription() {
            return "Loading test case from disk";
        }
    }
}

