/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import ch.e2e.builder.base.event.ApplicationClosingEvent;
import ch.e2e.builder.base.message.SendErrorEvent;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.event.RefreshRequestTreeEvent;
import ch.e2e.builder.trace.gui.model.TestcaseRequestModel;
import ch.e2e.builder.trace.gui.parameter.BigDecimalEditor;
import ch.e2e.builder.trace.gui.parameter.BigIntegerEditor;
import ch.e2e.builder.trace.gui.parameter.BooleanEditor;
import ch.e2e.builder.trace.gui.parameter.DateTimeCellEditor;
import ch.e2e.builder.trace.gui.parameter.StringEditor;
import ch.e2e.builder.trace.gui.testcase.AbstractXmlCodeInspector;
import ch.e2e.builder.trace.gui.testcase.DataTabbedView;
import ch.e2e.builder.trace.gui.tree.ParameterRenderer;
import ch.e2e.builder.trace.gui.watch.WatchRenderer;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.parameter.ArrayParameter;
import ch.e2e.builder.trace.testcase.parameter.BigDecimalParameter;
import ch.e2e.builder.trace.testcase.parameter.BigIntegerParameter;
import ch.e2e.builder.trace.testcase.parameter.BooleanParameter;
import ch.e2e.builder.trace.testcase.parameter.DateTimeParameter;
import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterTransferHandler;
import ch.e2e.builder.trace.testcase.parameter.RecordParameter;
import ch.e2e.builder.trace.testcase.parameter.StringParameter;
import ch.e2e.builder.trace.tree.TreeNodeChangedEvent;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecutionVetoException;
import ch.e2e.swing.Tree;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.swing.renderer.CellEditor;
import ch.e2e.swing.renderer.EditorContainer;
import ch.e2e.swing.renderer.RendererPreferences;
import com.jidesoft.action.CommandBar;
import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.marker.MarkerArea;
import com.jidesoft.swing.JideToggleButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class RequestTabbedView
extends DataTabbedView
implements DocumentListener,
FocusListener,
ActionListener,
TreeModelListener {
    private final SwitchModeBar commandBar = new SwitchModeBar(this);
    private boolean requestChanged = false;

    public RequestTabbedView(E2EBuilderModule module) {
        super(module, true);
        this.getEditor().addFocusListener(this);
        this.getEditor().setUseCodeInspector(true);
        this.getEditor().addCodeInspectionListener(this.commandBar);
        this.getEditor().addCodeInspectionListener(new AbstractXmlCodeInspector.CodeInspectionListener(){

            @Override
            public void inspectionStatusChanged(AbstractXmlCodeInspector.CodeInspectionEvent event) {
                try {
                    RequestTabbedView.this.getTestcase().getRequest().setHasErrors(!event.isInspectionSuccessful());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.getEditorPanel().add((Component)new MarkerArea((CodeEditor)this.getEditor()), "After");
        this.addEventHandler();
    }

    @Override
    public void setTestcase(Testcase testcase) {
        if (this.requestChanged && this.getTestcase() != null && !this.getTestcase().equals((Object)testcase)) {
            if ("xml".equals(this.getMode())) {
                this.reloadRequest();
            }
            this.saveRequest(this.getTestcase());
        }
        this.requestChanged = false;
        this.getTree().getModel().removeTreeModelListener(this);
        super.setTestcase(testcase);
        this.getTree().getModel().addTreeModelListener(this);
        if (testcase != null && testcase.isRPCEncoding()) {
            this.commandBar.setMode(this.getMode());
            this.addCommandBar(this.commandBar);
        } else {
            this.removeCommandBar();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        AbstractSynchronousTestcase testcase = (AbstractSynchronousTestcase)this.getTestcase();
        if (testcase != null && testcase.isRPCEncoding()) {
            if (this.getTree().isEditing()) {
                this.getTree().stopEditing();
            }
            if (this.requestChanged) {
                if ("rpc".equals(event.getActionCommand())) {
                    this.reloadRequest();
                    this.saveRequest((Testcase)testcase);
                } else if ("xml".equals(event.getActionCommand())) {
                    try {
                        this.getEditor().getDocument().removeDocumentListener((DocumentListener)this);
                        this.getEditor().setText(DomUtilities.asString((Node)testcase.getRequest().createRequestDocument()));
                        this.getEditor().getDocument().addDocumentListener((DocumentListener)this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    throw new IllegalStateException("Unsupported card in request tab CardLayout");
                }
            }
            this.setMode(event.getActionCommand());
            this.requestChanged = false;
        }
    }

    @Override
    protected Tree createTree() {
        TestcaseRequestModel requestTableModel = new TestcaseRequestModel(this.module);
        requestTableModel.addTreeModelListener(this);
        RendererPreferences preferences = new RendererPreferences((AbstractTreeModel)requestTableModel);
        WatchRenderer cellRenderer = new WatchRenderer(preferences);
        Tree tree = new Tree((AbstractTreeModel)requestTableModel, (TreeCellRenderer)cellRenderer);
        CellEditor editor = new CellEditor(tree, preferences, null);
        tree.setEditable(true);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setInvokesStopCellEditing(true);
        editor.setEditorContainer((EditorContainer)new ParameterRenderer(preferences));
        tree.setCellEditor((TreeCellEditor)editor);
        tree.setTransferHandler((TransferHandler)new ParameterTransferHandler());
        tree.setEditor(BooleanParameter.class, (TreeCellEditor)new BooleanEditor(this.module));
        tree.setEditor(BigIntegerParameter.class, (TreeCellEditor)new BigIntegerEditor(this.module));
        tree.setEditor(BigDecimalParameter.class, (TreeCellEditor)new BigDecimalEditor(this.module));
        tree.setEditor(DateTimeParameter.class, (TreeCellEditor)new DateTimeCellEditor(this.module));
        tree.setEditor(StringParameter.class, (TreeCellEditor)new StringEditor(this.module));
        return tree;
    }

    private void addCommandBar(CommandBar commandBar) {
        this.add((Component)commandBar, "North");
    }

    private void removeCommandBar() {
        Component comp = ((BorderLayout)this.getLayout()).getLayoutComponent("North");
        if (comp != null) {
            this.remove(comp);
        }
    }

    @Override
    public void refresh() {
    }

    private void saveRequest(Testcase testcase) {
        try {
            testcase.getRequest().save(this.requestChanged);
        }
        catch (Exception e) {
            EventController.fire((EventObject)new SendErrorEvent((Object)this, e.getLocalizedMessage(), null, this.module.getName(), null));
        }
    }

    @Override
    public void requestFocus() {
        if (this.getTestcase() != null && this.getTestcase().isRPCEncoding()) {
            this.getTree().requestFocus();
        }
    }

    @Override
    protected void setEditorText() {
        this.getEditor().getDocument().removeDocumentListener((DocumentListener)this);
        super.setEditorText();
        this.getEditor().getDocument().addDocumentListener((DocumentListener)this);
    }

    @Override
    protected String getData() {
        String data = null;
        try {
            data = this.getTestcase() == null ? null : this.getTestcase().getRequest().getRequest();
        }
        catch (Exception e) {
            EventController.fire((EventObject)new SendErrorEvent((Object)this, e.getLocalizedMessage(), null, this.module.getName(), null));
        }
        return data;
    }

    @Override
    protected long lastModified(Testcase testcase) {
        return testcase == null ? 0L : testcase.requestLastModified();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.requestChanged = true;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.requestChanged = true;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        if (((Parameter)e.getChildren()[0]).isChanged()) {
            this.requestChanged();
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.requestChanged();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.requestChanged();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.requestChanged();
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (this.requestChanged) {
            this.getTestcase().setStatus(7);
            ((AbstractSynchronousTestcase)this.getTestcase()).saveLastRunDate();
            EventController.fire((EventObject)new TreeNodeChangedEvent(this, (TestcaseObject)this.getTestcase()));
            if (this.reloadRequest()) {
                this.saveRequest(this.getTestcase());
                this.requestChanged = false;
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    private void requestChanged() {
        this.requestChanged = true;
        if (this.getTestcase() != null && this.getTestcase().getStatus() != 7) {
            this.getTestcase().setStatus(7);
            ((AbstractSynchronousTestcase)this.getTestcase()).saveLastRunDate();
            EventController.fire((EventObject)new TreeNodeChangedEvent(this, (TestcaseObject)this.getTestcase()));
        }
    }

    private boolean reloadRequest() {
        boolean reloaded = false;
        AbstractSynchronousTestcase testcase = (AbstractSynchronousTestcase)this.getTestcase();
        try {
            if (testcase.isRPCEncoding()) {
                Document document = this.getEditor().getXmlDocument();
                testcase.getRequest().reload(document.getDocumentElement(), testcase.getTemplate().getRequestTemplate());
                this.getTree().getModel().removeTreeModelListener(this);
                this.getTree().refresh();
                this.getTree().getModel().addTreeModelListener(this);
            } else {
                testcase.getRequest().reload(this.getEditor().getText());
            }
            reloaded = true;
        }
        catch (SAXParseException document) {
        }
        catch (Exception e) {
            EventController.fire((EventObject)new SendErrorEvent((Object)this, e.getLocalizedMessage(), null, this.module.getName(), null));
            e.printStackTrace();
        }
        return reloaded;
    }

    private void addEventHandler() {
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                RequestTabbedView.this.getTree().refresh();
            }
        }, RefreshRequestTreeEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) throws EventExecutionVetoException {
                if (RequestTabbedView.this.getTree().getInvokesStopCellEditing() && RequestTabbedView.this.getTree().isEditing()) {
                    RequestTabbedView.this.getTree().stopEditing();
                }
                if (RequestTabbedView.this.requestChanged) {
                    RequestTabbedView.this.getTestcase().setStatus(7);
                    ((AbstractSynchronousTestcase)RequestTabbedView.this.getTestcase()).saveLastRunDate();
                    if ("rpc".equals(RequestTabbedView.this.getMode()) || RequestTabbedView.this.reloadRequest()) {
                        RequestTabbedView.this.saveRequest(RequestTabbedView.this.getTestcase());
                    }
                }
            }
        }, ApplicationClosingEvent.class);
        this.getTree().setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container focusCycleRoot) {
                return RequestTabbedView.this.getTree();
            }

            @Override
            public Component getFirstComponent(Container focusCycleRoot) {
                return RequestTabbedView.this.getTree();
            }

            @Override
            public Component getLastComponent(Container focusCycleRoot) {
                return RequestTabbedView.this.getTree();
            }

            @Override
            public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                return RequestTabbedView.this.getTree();
            }

            @Override
            public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
                return RequestTabbedView.this.getTree();
            }
        });
        this.addInsertAction();
        this.addEnterAction();
        this.addDeleteAction();
        this.addSetNullAction();
    }

    private void addInsertAction() {
        KeyStroke tabStroke = KeyStroke.getKeyStroke(155, 0);
        InputMap inputMap = this.getTree().getInputMap();
        inputMap.put(tabStroke, "ch.e2e.builder.debubgger.requestTree.Insert");
        this.getTree().getActionMap().put("ch.e2e.builder.debubgger.requestTree.Insert", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RequestTabbedView.this.insertItem();
            }
        });
    }

    private void addEnterAction() {
        KeyStroke tabStroke = KeyStroke.getKeyStroke(10, 0);
        InputMap inputMap = this.getTree().getInputMap();
        inputMap.put(tabStroke, "ch.e2e.builder.debubgger.requestTree.Enter");
        this.getTree().getActionMap().put("ch.e2e.builder.debubgger.requestTree.Enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RequestTabbedView.this.createItem();
            }
        });
    }

    private void addDeleteAction() {
        KeyStroke tabStroke = KeyStroke.getKeyStroke(127, 0);
        InputMap inputMap = this.getTree().getInputMap();
        inputMap.put(tabStroke, "ch.e2e.builder.debubgger.requestTree.Delete");
        this.getTree().getActionMap().put("ch.e2e.builder.debubgger.requestTree.Delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RequestTabbedView.this.deleteItem();
            }
        });
    }

    private void addSetNullAction() {
        KeyStroke tabStroke = KeyStroke.getKeyStroke(8, 0);
        InputMap inputMap = this.getTree().getInputMap();
        inputMap.put(tabStroke, "ch.e2e.builder.debubgger.requestTree.BackSpace");
        this.getTree().getActionMap().put("ch.e2e.builder.debubgger.requestTree.BackSpace", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RequestTabbedView.this.setItemNull();
            }
        });
    }

    private void createItem() {
        Object value;
        TreePath selectionPath = this.getTree().getSelectionPath();
        if (selectionPath != null && (value = selectionPath.getLastPathComponent()) instanceof RecordParameter && ((RecordParameter)value).isNull()) {
            ((RecordParameter)value).create();
            this.getTree().refresh();
            this.getTree().setSelectionPath(selectionPath);
        }
    }

    private void deleteItem() {
        Object value;
        TreePath selectionPath = this.getTree().getSelectionPath();
        if (selectionPath != null && (value = selectionPath.getLastPathComponent()) instanceof Parameter && ((Parameter)value).isArrayItem()) {
            Parameter parameter = (Parameter)value;
            ArrayParameter parent = (ArrayParameter)parameter.getParent();
            int index = parent.getIndexOfChild((Object)parameter);
            parent.removeItem(parameter);
            if (parent.getChildCount() == 0) {
                selectionPath = selectionPath.getParentPath();
            } else if (index == parent.getChildCount()) {
                Object[] path = selectionPath.getPath();
                path[path.length - 1] = parent.getChild(index - 1);
                selectionPath = new TreePath(path);
            } else {
                Object[] path = selectionPath.getPath();
                path[path.length - 1] = parent.getChild(index);
                selectionPath = new TreePath(path);
            }
            this.getTree().refresh();
            this.getTree().setSelectionPath(selectionPath);
        }
    }

    private void insertItem() {
        TreePath selectionPath = this.getTree().getSelectionPath();
        if (selectionPath != null) {
            Object value = selectionPath.getLastPathComponent();
            if (value instanceof ArrayParameter) {
                ArrayParameter parameter = (ArrayParameter)value;
                parameter.addItem();
                this.getTree().refresh();
                this.getTree().expandPath(selectionPath);
                Object[] path = new Object[selectionPath.getPath().length + 1];
                System.arraycopy(selectionPath.getPath(), 0, path, 0, selectionPath.getPath().length);
                path[selectionPath.getPath().length] = parameter.getChild(parameter.getChildCount() - 1);
                this.getTree().setSelectionPath(new TreePath(path));
            } else if (value instanceof Parameter && ((Parameter)value).isArrayItem()) {
                Parameter parameter = (Parameter)value;
                ArrayParameter parent = (ArrayParameter)parameter.getParent();
                Parameter newItem = parent.insertBehind(parameter);
                this.getTree().refresh();
                Object[] path = new Object[selectionPath.getParentPath().getPath().length + 1];
                System.arraycopy(selectionPath.getParentPath().getPath(), 0, path, 0, selectionPath.getParentPath().getPath().length);
                path[selectionPath.getParentPath().getPath().length] = newItem;
                this.getTree().setSelectionPath(new TreePath(path));
            }
        }
    }

    private void setItemNull() {
        Object value;
        TreePath selectionPath = this.getTree().getSelectionPath();
        if (selectionPath != null && (value = selectionPath.getLastPathComponent()) instanceof Parameter) {
            ((Parameter)value).setValue(null);
            this.getTree().refresh();
            this.getTree().setSelectionPath(selectionPath);
        }
    }

    private static class SwitchModeBar
    extends CommandBar
    implements AbstractXmlCodeInspector.CodeInspectionListener {
        private final Map<String, JideToggleButton> buttons = new HashMap<String, JideToggleButton>(2);

        private SwitchModeBar(ActionListener listener) {
            ButtonGroup group = new ButtonGroup();
            JideToggleButton b = new JideToggleButton("rpc");
            this.buttons.put("rpc", b);
            b.setFocusable(false);
            b.setSelected(true);
            b.addActionListener(listener);
            group.add((AbstractButton)b);
            this.add((Component)b);
            b = new JideToggleButton("xml");
            this.buttons.put("xml", b);
            b.setFocusable(false);
            b.addActionListener(listener);
            group.add((AbstractButton)b);
            this.add((Component)b);
        }

        public void setMode(String mode) {
            this.buttons.get(mode).setSelected(true);
        }

        @Override
        public void inspectionStatusChanged(AbstractXmlCodeInspector.CodeInspectionEvent event) {
            this.buttons.get("rpc").setEnabled(event.isInspectionSuccessful());
        }
    }
}

