/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import ch.e2e.builder.base.gui.E2EBuilderInfoDialog;
import ch.e2e.builder.trace.E2ETraceModule;
import ch.e2e.builder.trace.gui.testcase.Logging;
import ch.e2e.builder.trace.tools.Query;
import ch.e2e.util.StringTools;
import java.text.ParseException;
import java.util.HashMap;

public class MessageDisplay
implements Logging {
    private static MessageDisplay messageDisplay;
    private HashMap<String, String[]> messages = new HashMap();
    private String flowNotInspectedInternalTitle;
    private String flowNotInspectedMessage;
    private String flowNotInspectedSubtitle;
    private String testNotRunTitle;
    private String testNotRunSubtitle;
    private String testNotRunInternalTitle;
    private String testNotRunMessage;
    private E2ETraceModule module;

    private MessageDisplay(E2ETraceModule module) {
        this.module = module;
        this.flowNotInspectedInternalTitle = module.getTranslation("flow.not.inspected.internaltitle");
        this.flowNotInspectedMessage = module.getTranslation("flow.not.inspected.message");
        this.flowNotInspectedSubtitle = module.getTranslation("flow.not.inspected.subtitle");
        this.testNotRunTitle = module.getTranslation("testcase.not.run.title");
        this.testNotRunInternalTitle = module.getTranslation("testcase.not.run.internaltitle");
        this.testNotRunSubtitle = module.getTranslation("testcase.not.run.subtitle");
        this.testNotRunMessage = module.getTranslation("testcase.not.run.message");
    }

    public static MessageDisplay getInstance(E2ETraceModule module) {
        if (messageDisplay == null) {
            messageDisplay = new MessageDisplay(module);
        }
        return messageDisplay;
    }

    public void showMessage(Query query) {
        String parameter;
        String key = query.getParameter("key");
        String[] messages = this.messages.get(key);
        if (messages == null) {
            messages = new String[]{this.module.getTranslation(key + ".title", key), this.module.getTranslation(key + ".internaltitle", key), this.module.getTranslation(key + ".subtitle", key), this.module.getTranslation(key + ".message", key)};
            this.messages.put(key, messages);
        }
        String message = (parameter = query.getParameter("parameter")) == null ? messages[3] : StringTools.replaceProperties((String)messages[3], this.createParameterMap(parameter));
        String type = query.getParameter("type");
        if (type.equals("info")) {
            this.showInfoMessage(messages, message);
        } else if (type.equals("error")) {
            this.showErrorMessage(messages, message);
        }
    }

    public void showInfoMessage(String[] messages, String message) {
        E2EBuilderInfoDialog.info((String)messages[0], (String)messages[1], (String)messages[2], (String)message);
    }

    public void showErrorMessage(String[] messages, String message) {
        E2EBuilderInfoDialog.error((String)messages[0], (String)messages[1], (String)messages[2], (String)message);
    }

    public void showTestcaseNotRunMessage() {
        E2EBuilderInfoDialog.info((String)this.testNotRunTitle, (String)this.testNotRunInternalTitle, (String)this.testNotRunSubtitle, (String)this.testNotRunMessage);
    }

    public void showTestcaseFlowNotInspectedMessage(String flow) {
        E2EBuilderInfoDialog.warning((String)this.flowNotInspectedInternalTitle, (String)this.flowNotInspectedSubtitle, (String)StringTools.replaceProperty((String)this.flowNotInspectedMessage, (String)"flow", (String)flow));
    }

    public HashMap<String, String> createParameterMap(String parameter) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        try {
            String[] parameterArray = StringTools.createStringArray((String)parameter);
            for (int i = 0; i < parameterArray.length; i += 2) {
                parameterMap.put(parameterArray[i], parameterArray[i + 1]);
            }
        }
        catch (ParseException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "createParameter", e);
        }
        return parameterMap;
    }
}

