/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.model;

import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.swing.renderer.RendererPreferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.TreeCellRenderer;

public class WSDLTreeRenderer
extends JPanel
implements TreeCellRenderer {
    private Color unselectedBackground;
    private Color selectedBackground;
    private Color selectedForeground;
    private Color locationColor;
    private Color unselectedForeground;
    private JLabel iconLabel;
    private JLabel nameLabel;
    private JLabel locationLabel;
    protected JPanel labelPanel;
    private JLabel defaultLabel;
    private RendererPreferences preferences;
    private Color selectedBorder;

    public WSDLTreeRenderer(RendererPreferences preferences) {
        this.preferences = preferences;
        this.locationColor = preferences.getProperties().getColor("testcase.location.color", Color.BLUE);
        this.createGui();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JComponent result;
        if (value instanceof TestcaseObject) {
            int type = this.preferences.getType(value);
            this.setIcon(type, leaf, expanded, selected);
            this.setLabelVisibility((TestcaseObject)value);
            if (selected) {
                this.setSelectedColors(type);
                if (hasFocus) {
                    this.labelPanel.setBorder(new LineBorder(this.selectedBorder, 1));
                } else {
                    this.labelPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
                }
            } else {
                this.labelPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
                this.setUnselectedColors(type, leaf, expanded);
            }
            result = this;
            tree.setToolTipText(this.preferences.getTooltip(value));
        } else {
            this.defaultLabel.setText(value.toString());
            result = this.defaultLabel;
        }
        return result;
    }

    private void setLabelVisibility(TestcaseObject value) {
        this.nameLabel.setText(value.getName());
        if (value instanceof Testcase) {
            this.locationLabel.setText('(' + ((Testcase)value).getLocation() + ')');
        } else {
            this.locationLabel.setText("");
        }
    }

    private void setIcon(int type, boolean leaf, boolean expanded, boolean selected) {
        Icon[] icons = this.preferences.getIcons(type, leaf, expanded, selected);
        if (icons[0] != null) {
            this.iconLabel.setIcon(icons[0]);
            this.iconLabel.setDisabledIcon(icons[1]);
        }
    }

    private void setSelectedColors(int type) {
        this.labelPanel.setBackground(this.selectedBackground);
        Color[] colors = this.preferences.getSelectedColors(type);
        this.nameLabel.setBackground(colors[0]);
        this.nameLabel.setForeground(colors[1]);
        this.locationLabel.setForeground(this.selectedForeground);
        this.locationLabel.setBackground(this.selectedBackground);
    }

    private void setUnselectedColors(int type, boolean leaf, boolean expanded) {
        this.labelPanel.setBackground(this.unselectedBackground);
        this.nameLabel.setBackground(this.unselectedBackground);
        this.locationLabel.setBackground(this.unselectedBackground);
        this.nameLabel.setForeground(this.preferences.getColor(type, leaf, expanded));
        this.locationLabel.setForeground(this.locationColor);
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setOpaque(false);
        return label;
    }

    private void createGui() {
        this.setLayout(new BorderLayout());
        this.unselectedForeground = UIManager.getColor("Tree.textForeground");
        this.unselectedBackground = UIManager.getColor("Tree.textBackground");
        this.selectedForeground = UIManager.getColor("Tree.selectionForeground");
        this.selectedBackground = UIManager.getColor("Tree.selectionBackground");
        this.setBackground(this.unselectedBackground);
        this.setOpaque(false);
        this.labelPanel = new JPanel(new BorderLayout());
        this.labelPanel.setOpaque(false);
        this.iconLabel = this.createLabel("");
        this.iconLabel.setBackground(this.unselectedBackground);
        this.iconLabel.setBorder(new EmptyBorder(0, 0, 0, 3));
        this.nameLabel = this.createLabel("");
        this.locationLabel = this.createLabel("");
        this.add((Component)this.iconLabel, "West");
        this.nameLabel.setBorder(new EmptyBorder(0, 0, 0, 3));
        this.labelPanel.add((Component)this.nameLabel, "Center");
        this.labelPanel.add((Component)this.locationLabel, "East");
        this.add((Component)this.labelPanel, "Center");
        this.selectedBorder = UIManager.getColor("Tree.selectionBorderColor");
        this.defaultLabel = new JLabel();
    }
}

