/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute.test;

import java.io.File;
import org.custommonkey.xmlunit.Diff;

public class TestcaseDifference {
    private StringBuffer messages = new StringBuffer();
    private boolean identical = true;
    private File testFolder;
    private File referenceFolder;

    public TestcaseDifference(File testFolder, File referenceFolder) {
        this.testFolder = testFolder;
        this.referenceFolder = referenceFolder;
    }

    public void addMissingEntry(String name) {
        this.messages.append("Missing file '").append(name).append("' in directory ").append(this.testFolder.getAbsolutePath()).append(".\n");
        this.identical = false;
    }

    public void addAdditionalEntry(String name) {
        this.messages.append("Additional file '").append(name).append("' in directory ").append(this.testFolder.getAbsolutePath()).append(" found.\n");
        this.identical = false;
    }

    public void appendXMLDiff(Diff xmlDiff) {
        if (!xmlDiff.identical()) {
            StringBuffer diffMessages = new StringBuffer();
            xmlDiff.appendMessage(diffMessages);
            this.messages.append(diffMessages).append('\n');
            this.identical = false;
        }
    }

    public void addException(Throwable exception, File file) {
        this.messages.append(file.getAbsolutePath()).append(": ").append(exception.getMessage()).append('\n');
    }

    public boolean isIdentical() {
        return this.identical;
    }

    public String toString() {
        return this.messages.toString();
    }
}

