/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.fop.render.afp.modca.AbstractAFPObject;
import org.apache.fop.render.afp.tools.BinaryUtils;

public class TagLogicalElement
extends AbstractAFPObject {
    private String tleName = null;
    private String tleValue = null;
    private byte[] tleByteName = null;
    private byte[] tleByteValue = null;

    public TagLogicalElement(String name, String value) {
        this.tleName = name;
        this.tleValue = value;
        try {
            this.tleByteName = name.getBytes("Cp1146");
            this.tleByteValue = value.getBytes("Cp1146");
        }
        catch (UnsupportedEncodingException usee) {
            this.tleByteName = name.getBytes();
            this.tleByteValue = value.getBytes();
            log.warn((Object)("Constructor:: UnsupportedEncodingException translating the name " + name));
        }
    }

    public void writeDataStream(OutputStream os) throws IOException {
        byte[] data = new byte[17 + this.tleName.length() + this.tleValue.length()];
        data[0] = 90;
        byte[] rl1 = BinaryUtils.convert(16 + this.tleName.length() + this.tleValue.length(), 2);
        data[1] = rl1[0];
        data[2] = rl1[1];
        data[3] = -45;
        data[4] = -96;
        data[5] = -112;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        byte[] rl2 = BinaryUtils.convert(this.tleName.length() + 4, 1);
        data[9] = rl2[0];
        data[10] = 2;
        data[11] = 11;
        data[12] = 0;
        int pos = 13;
        for (int i = 0; i < this.tleByteName.length; ++i) {
            data[pos++] = this.tleByteName[i];
        }
        byte[] rl3 = BinaryUtils.convert(this.tleByteValue.length + 4, 1);
        data[pos++] = rl3[0];
        data[pos++] = 54;
        data[pos++] = 0;
        data[pos++] = 0;
        for (int i = 0; i < this.tleByteValue.length; ++i) {
            data[pos++] = this.tleByteValue[i];
        }
        os.write(data);
    }
}

