/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.fop.fonts.BFEntry;
import org.apache.fop.fonts.CIDFontType;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFCmapEntry;
import org.apache.fop.fonts.truetype.TTFFile;

public class TTFFontLoader
extends FontLoader {
    private MultiByteFont multiFont;

    public TTFFontLoader(String fontFileURI, FontResolver resolver) {
        super(fontFileURI, resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read() throws IOException {
        InputStream in = TTFFontLoader.openFontUri(this.resolver, this.fontFileURI);
        try {
            TTFFile ttf = new TTFFile();
            FontFileReader reader = new FontFileReader(in);
            boolean supported = ttf.readFont(reader, null);
            if (!supported) {
                throw new IOException("TrueType font is not supported: " + this.fontFileURI);
            }
            this.buildFont(ttf);
            this.loaded = true;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private void buildFont(TTFFile ttf) {
        if (ttf.isCFF()) {
            throw new UnsupportedOperationException("OpenType fonts with CFF data are not supported, yet");
        }
        this.multiFont = new MultiByteFont();
        this.multiFont.setResolver(this.resolver);
        this.returnFont = this.multiFont;
        this.returnFont.setFontName(ttf.getPostScriptName());
        this.returnFont.setFullName(ttf.getFullName());
        this.returnFont.setFamilyNames(ttf.getFamilyNames());
        this.returnFont.setFontSubFamilyName(ttf.getSubFamilyName());
        this.returnFont.setCapHeight(ttf.getCapHeight());
        this.returnFont.setXHeight(ttf.getXHeight());
        this.returnFont.setAscender(ttf.getLowerCaseAscent());
        this.returnFont.setDescender(ttf.getLowerCaseDescent());
        this.returnFont.setFontBBox(ttf.getFontBBox());
        this.returnFont.setFlags(ttf.getFlags());
        this.returnFont.setStemV(Integer.parseInt(ttf.getStemV()));
        this.returnFont.setItalicAngle(Integer.parseInt(ttf.getItalicAngle()));
        this.returnFont.setMissingWidth(0);
        this.returnFont.setWeight(ttf.getWeightClass());
        this.multiFont.setCIDType(CIDFontType.CIDTYPE2);
        int[] wx = ttf.getWidths();
        this.multiFont.setWidthArray(wx);
        List entries = ttf.getCMaps();
        BFEntry[] bfentries = new BFEntry[entries.size()];
        int pos = 0;
        ListIterator iter = ttf.getCMaps().listIterator();
        while (iter.hasNext()) {
            TTFCmapEntry ce = (TTFCmapEntry)iter.next();
            bfentries[pos] = new BFEntry(ce.getUnicodeStart(), ce.getUnicodeEnd(), ce.getGlyphStartIndex());
            ++pos;
        }
        this.multiFont.setBFEntries(bfentries);
        this.copyKerning(ttf, true);
        this.multiFont.setEmbedFileName(this.fontFileURI);
    }

    private void copyKerning(TTFFile ttf, boolean isCid) {
        Iterator iter = isCid ? ttf.getKerning().keySet().iterator() : ttf.getAnsiKerning().keySet().iterator();
        while (iter.hasNext()) {
            Integer kpx1 = (Integer)iter.next();
            Map h2 = isCid ? (Map)ttf.getKerning().get(kpx1) : (Map)ttf.getAnsiKerning().get(kpx1);
            this.returnFont.putKerningEntry(kpx1, h2);
        }
    }
}

