/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.expr.FunctionBase;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.expr.RGBColorFunction;
import org.apache.fop.fo.pagination.ColorProfile;
import org.apache.fop.fo.pagination.Declarations;
import org.apache.fop.fo.properties.ColorProperty;
import org.apache.fop.fo.properties.Property;

class ICCColorFunction
extends FunctionBase {
    ICCColorFunction() {
    }

    public int nbArgs() {
        return -4;
    }

    public PercentBase getPercentBase() {
        return new ICCPercentBase();
    }

    public Property eval(Property[] args, PropertyInfo pInfo) throws PropertyException {
        String colorProfileName = args[3].getString();
        Declarations decls = pInfo.getFO().getRoot().getDeclarations();
        ColorProfile cp = null;
        if (decls == null) {
            Property[] rgbArgs = new Property[3];
            System.arraycopy(args, 0, rgbArgs, 0, 3);
            return new RGBColorFunction().eval(rgbArgs, pInfo);
        }
        cp = decls.getColorProfile(colorProfileName);
        if (cp == null) {
            PropertyException pe = new PropertyException("The " + colorProfileName + " color profile was not declared");
            pe.setPropertyInfo(pInfo);
            throw pe;
        }
        String src = cp.getSrc();
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        red = args[0].getNumber().floatValue();
        green = args[1].getNumber().floatValue();
        blue = args[2].getNumber().floatValue();
        if (red < 0.0f || red > 255.0f || green < 0.0f || green > 255.0f || blue < 0.0f || blue > 255.0f) {
            throw new PropertyException("Color values out of range. Arguments to rgb-icc() must be [0..255] or [0%..100%]");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("fop-rgb-icc(");
        sb.append(red / 255.0f);
        sb.append(',').append(green / 255.0f);
        sb.append(',').append(blue / 255.0f);
        for (int ix = 3; ix < args.length; ++ix) {
            if (ix == 3) {
                sb.append(',').append(colorProfileName);
                sb.append(',').append(src);
                continue;
            }
            sb.append(',').append(args[ix]);
        }
        sb.append(")");
        return ColorProperty.getInstance(pInfo.getUserAgent(), sb.toString());
    }

    private static final class ICCPercentBase
    implements PercentBase {
        private ICCPercentBase() {
        }

        public int getBaseLength(PercentBaseContext context) throws PropertyException {
            return 0;
        }

        public double getBaseValue() {
            return 255.0;
        }

        public int getDimension() {
            return 0;
        }
    }
}

