/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.tools;

import ch.e2e.io.FileUtilities;

public class TraceTools {
    public static final String ADAPTER_TEMPLATES_FILENAME = "adapter.templates";
    public static final String ADAPTER_TEMPLATE_IDS = "adapter.template.ids";
    public static final String INSPECTION_LIST_FILENAME = "inspection.list";
    public static final String ZIPFILE_EXTENSION = ".zip";
    public static final String REPOSITORY_ASYNCHRONOUS_ENTRY = "asynchronous.trace";

    private TraceTools() {
    }

    public static String createPrefix(String name) {
        String keyPrefix = "";
        while (keyPrefix.length() < 10 && keyPrefix.length() < name.length()) {
            keyPrefix = TraceTools.findPrefixString(name.substring(0, name.length() - keyPrefix.length()), keyPrefix);
        }
        if ((keyPrefix = FileUtilities.getFilename((String)keyPrefix, (char)'\u0000', (boolean)true)).length() > 10) {
            keyPrefix = keyPrefix.substring(0, 10);
        }
        return keyPrefix.trim();
    }

    static String findPrefixString(String name, String keyPrefix) {
        String lastChar;
        if (keyPrefix.length() == 0) {
            lastChar = "";
        } else {
            lastChar = String.valueOf(name.charAt(name.length() - 1));
            name = name.substring(0, name.length() - 1);
        }
        int index = TraceTools.lastIndexOf(name, '.', Integer.MAX_VALUE);
        if (index == -1) {
            index = TraceTools.lastIndexOf(name, '/', Integer.MAX_VALUE);
        }
        if (index == -1) {
            index = TraceTools.lastIndexOf(name, '\\', Integer.MAX_VALUE);
        }
        keyPrefix = index == -1 ? name + lastChar + keyPrefix : name.substring(index + 1) + lastChar + keyPrefix;
        return keyPrefix;
    }

    private static int lastIndexOf(String s, char c, int pos) {
        int last = s.length() - 1;
        int i = s.lastIndexOf(c, pos);
        if (!(i == -1 || i != last && Character.isJavaIdentifierPart(s.codePointAt(i + 1)))) {
            return TraceTools.lastIndexOf(s, c, i - 1);
        }
        return i;
    }
}

