/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.tools;

import ch.e2e.builder.trace.testcase.response.ActionScriptTransformer;
import ch.e2e.builder.trace.testcase.uml.TypeMapper;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.ZipUtilities;
import ch.e2e.transformer.TransformerLoadException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ActionScriptHelper {
    private static final String SCRIPTIO_PREFIX = "SCRIPTIO_";
    private static final String MESSAGEIO_PREFIX = "MESSAGEIO_";
    private static final Pattern PATTERN = Pattern.compile("(?<!=\")SCRIPTIO_[A-Z]+[0-9]+|MESSAGEIO_MESSAGE[0-9]+");
    private final Matcher matcher = PATTERN.matcher("");
    private final File ioFile;

    public ActionScriptHelper(File ioFile) {
        this.ioFile = ioFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolveActionScriptIOFromId(String scriptId) throws IOException, TransformerException, TransformerLoadException {
        String script = null;
        File scriptFile = new File(this.ioFile.getParentFile(), scriptId + ".asl");
        if (scriptFile.canRead()) {
            StringWriter to = new StringWriter();
            try {
                FileUtilities.copy((Reader)new FileReader(scriptFile), (Writer)to);
                script = to.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (script == null) {
            ZipFile zipFile = null;
            OutputStreamWriter writer = null;
            try {
                zipFile = new ZipFile(this.ioFile);
                ZipEntry entry = zipFile.getEntry(scriptId);
                if (entry != null && (script = new ActionScriptTransformer().transform(zipFile.getInputStream(entry))) != null) {
                    script = this.resolveActionScriptIO(script);
                    writer = new FileWriter(scriptFile);
                    writer.write(script);
                }
            }
            finally {
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolveActionScriptIO(String script) {
        StringBuilder result = new StringBuilder();
        BufferedReader reader = new BufferedReader(new StringReader(script));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(this.processLine(line));
                result.append("\n");
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return result.toString();
    }

    private String processLine(String line) {
        StringBuilder result = new StringBuilder(line);
        ArrayList<Replacement> replacements = new ArrayList<Replacement>();
        this.matcher.reset(line);
        while (this.matcher.find()) {
            String match = this.matcher.group();
            if (match.startsWith(SCRIPTIO_PREFIX)) {
                this.replaceScriptIO(match, this.matcher.start(), this.matcher.end(), replacements);
                continue;
            }
            if (!match.startsWith(MESSAGEIO_PREFIX)) continue;
            this.replaceMessageIO(match, this.matcher.start(), this.matcher.end(), replacements);
        }
        int nReplacements = replacements.size();
        for (int i = nReplacements - 1; i > -1; --i) {
            Replacement replacement = (Replacement)replacements.get(i);
            result.replace(replacement.start, replacement.end, replacement.value);
        }
        return result.toString();
    }

    private void replaceScriptIO(String match, int start, int end, List<Replacement> replacements) {
        try {
            Document document = ZipUtilities.getZippedDocumentFromFile((File)this.ioFile, (String)match);
            if (document != null) {
                String value;
                Element element = document.getDocumentElement();
                String type = ((Element)element.getFirstChild()).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                if (TypeMapper.isSimpleType(TypeMapper.bridgeType2XSD(type))) {
                    value = element.getTextContent();
                } else {
                    String name = element.getFirstChild().getNodeName();
                    int index = name.indexOf("...");
                    if (index > -1) {
                        name = name.substring(0, index);
                    }
                    value = "<a href=\"" + match + "\">" + name + "</a>";
                }
                replacements.add(new Replacement(start, end, value));
            }
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    private void replaceMessageIO(String match, int start, int end, List<Replacement> replacements) {
        try {
            Document document = ZipUtilities.getZippedDocumentFromFile((File)this.ioFile, (String)match.substring(MESSAGEIO_PREFIX.length()));
            if (document != null) {
                String value = document.getElementsByTagName("description").item(0).getTextContent();
                replacements.add(new Replacement(start, end, value));
            }
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    private static class Replacement {
        private int start;
        private int end;
        private String value;

        public Replacement(int start, int end, String value) {
            this.start = start;
            this.end = end;
            this.value = value;
        }
    }
}

