/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.Flow;
import ch.e2e.builder.trace.testcase.uml.Script;
import ch.e2e.builder.trace.testcase.uml.ScriptObject;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import java.io.File;
import org.w3c.dom.Element;

public class TransformerFlow
extends Flow {
    private static final String STEREOTYPE = "ActionScript";
    private Script script;

    public TransformerFlow(Element flowElement, File documentFolder) {
        super(flowElement, documentFolder);
    }

    public TransformerFlow(Element element, TraceContainer traceContainer) {
        super(element, traceContainer);
        this.removeContainerElements(element, traceContainer);
    }

    public TransformerFlow(Element element, TraceContainer traceContainer, boolean addToContainer) {
        super(element, traceContainer, addToContainer);
    }

    @Override
    public int internalGetType() {
        return 10021;
    }

    @Override
    public void addChild(UmlObject child) {
        if (child instanceof ScriptObject) {
            if (this.script == null) {
                this.script = new Script();
                super.addChild(this.script);
            }
            this.script.error |= child.error;
            this.script.addChild(child);
        } else {
            super.addChild(child);
        }
    }

    @Override
    protected void addChild(Element child, File documentFolder) {
        if (child.getNodeName().equals("Script")) {
            this.script = new Script(child, documentFolder);
            super.addChild(this.script);
        } else {
            super.addChild(child, documentFolder);
        }
    }

    @Override
    protected void removeContainerElements(Element element, TraceContainer traceContainer) {
        if (this.script != null) {
            Element scriptElement = element.getOwnerDocument().createElement("Script");
            scriptElement.setAttribute("id", traceContainer.addScript(this.script));
            if (this.script.error) {
                scriptElement.setAttribute("error", "true");
            }
            ScriptObject scriptPart = this.script.getScriptPart(0);
            element.replaceChild(scriptElement, scriptPart.getXmlElement());
            scriptPart.clearXmlElement();
            int length = this.script.getChildCount();
            for (int i = 1; i < length; ++i) {
                scriptPart = this.script.getScriptPart(i);
                element.removeChild(scriptPart.getXmlElement());
                scriptPart.clearXmlElement();
            }
        }
    }

    public Script getScript() {
        return this.script;
    }

    @Override
    public String getStereotype() {
        return STEREOTYPE;
    }
}

