/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.uml.Script;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IOContainer {
    private File file;
    private int ioId;
    private ZipOutputStream ioZipFile;

    public IOContainer(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public String addScript(Script script) {
        String id = "SCRIPT" + String.valueOf(this.ioId++);
        Document scriptDocument = DomUtilities.newDocument((String)"SCRIPT");
        Element root = scriptDocument.getDocumentElement();
        int length = script.getChildCount();
        for (int i = 0; i < length; ++i) {
            root.appendChild(scriptDocument.importNode(script.getScriptPart(i).getXmlElement(), true));
        }
        try {
            ZipOutputStream out = this.getIOZipFile();
            out.putNextEntry(new ZipEntry(id));
            DomUtilities.serialize((OutputStream)out, (Document)scriptDocument, (boolean)false, (boolean)false);
            out.closeEntry();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    public String addIOEntry(Element ioNode, String type) {
        String id = type + String.valueOf(this.ioId++);
        Document ioDocument = DomUtilities.newDocument((String)type);
        Element root = ioDocument.getDocumentElement();
        Node importedNode = ioDocument.importNode(ioNode, true);
        root.appendChild(importedNode);
        try {
            ZipOutputStream out = this.getIOZipFile();
            out.putNextEntry(new ZipEntry(id));
            DomUtilities.serialize((OutputStream)out, (Document)ioDocument, (boolean)false, (boolean)false);
            out.closeEntry();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int length = ioNode.getChildNodes().getLength();
        for (int i = 0; i < length; ++i) {
            ioNode.removeChild(ioNode.getFirstChild());
        }
        ioNode.appendChild(ioNode.getOwnerDocument().createTextNode(id));
        return id;
    }

    public void close() {
        if (this.ioZipFile != null) {
            try {
                this.ioZipFile.flush();
                this.ioZipFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private ZipOutputStream getIOZipFile() {
        if (this.ioZipFile == null) {
            try {
                this.ioZipFile = new ZipOutputStream(new FileOutputStream(this.file));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return this.ioZipFile;
    }
}

