/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.Script;
import ch.e2e.builder.trace.testcase.uml.ScriptObject;
import ch.e2e.builder.trace.testcase.uml.State;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public class Branches
extends UmlObject {
    private List<Script> branches;

    public Branches(Element element, File documentFolder) {
        super(element, documentFolder);
        if (this.branches == null) {
            this.branches = Collections.emptyList();
        }
    }

    public Branches(Element element, TraceContainer traceContainer) {
        super(element, traceContainer);
        if (this.branches == null) {
            this.branches = Collections.emptyList();
        }
        this.removeContainerElements(element, traceContainer);
    }

    @Override
    public int internalGetType() {
        return 10007;
    }

    @Override
    public void addChild(UmlObject child) {
        if (child instanceof ScriptObject) {
            Script script = new Script();
            script.error |= child.error;
            script.addChild(child);
            this.add(script);
            super.addChild(child);
        } else {
            super.addChild(child);
        }
    }

    @Override
    protected void addChild(Element child, TraceContainer traceContainer) {
        String name = child.getNodeName();
        if ("branch".equals(name)) {
            Script script = new Script();
            script.addChild(child, traceContainer);
            this.add(script);
            super.addChild(script);
        } else if ("state".equals(name)) {
            super.addChild(child, traceContainer);
        }
    }

    @Override
    protected void addChild(Element child, File documentFolder) {
        String name = child.getNodeName();
        if ("Script".equals(name)) {
            Script script = new Script(child, documentFolder);
            this.add(script);
            super.addChild(script);
        } else {
            super.addChild(child, documentFolder);
        }
    }

    private void add(Script script) {
        if (this.branches == null) {
            this.branches = new ArrayList<Script>();
        }
        this.branches.add(script);
    }

    public List<Script> getBranches() {
        return this.branches;
    }

    public Script getFollowedBranch() {
        List<Script> scripts = this.getBranches();
        int nBranches = scripts.size();
        return nBranches == 0 ? null : scripts.get(nBranches - 1);
    }

    public List<Script> getNotFollowedBranches() {
        List<Script> scripts = this.getBranches();
        int nBranches = scripts.size();
        return nBranches > 1 ? scripts.subList(0, nBranches - 1) : Collections.emptyList();
    }

    protected void removeContainerElements(Element element, TraceContainer traceContainer) {
        for (Script script : this.getBranches()) {
            Element scriptElement = element.getOwnerDocument().createElement("Script");
            scriptElement.setAttribute("id", traceContainer.addScript(script));
            ScriptObject scriptPart = script.getScriptPart(0);
            if (scriptPart != null) {
                element.replaceChild(scriptElement, scriptPart.getXmlElement());
            }
            script.cleanScriptParts();
        }
    }

    @Override
    public String getStereotype() {
        return null;
    }

    public State getState() {
        return this.getFirstChild(State.class);
    }
}

