/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.AdapterIOInput;
import ch.e2e.builder.trace.testcase.uml.AdapterIOOutput;
import ch.e2e.builder.trace.testcase.uml.IOUmlObject;
import java.io.File;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AdapterIO
extends IOUmlObject {
    private String ioId;

    public AdapterIO(Element element, File documentFolder) {
        super(element, documentFolder);
        this.setIoId(element);
    }

    public AdapterIO(Element element, TraceContainer traceContainer) {
        super(element, traceContainer);
        this.setIoId(element);
    }

    @Override
    protected void addChild(Element child, TraceContainer traceContainer) {
        if (child.getNodeName().equals("input")) {
            this.setInput(new AdapterIOInput(this, child, traceContainer));
        } else if (child.getNodeName().equals("output")) {
            this.setOutput(new AdapterIOOutput(this, child, traceContainer));
        } else {
            super.addChild(child, traceContainer);
        }
    }

    @Override
    protected void addChild(Element child, File documentFolder) {
        if (child.getNodeName().equals("input")) {
            this.setInput(new AdapterIOInput(this, child));
        } else if (child.getNodeName().equals("output")) {
            this.setOutput(new AdapterIOOutput(this, child));
        } else {
            super.addChild(child, documentFolder);
        }
    }

    public String getIoId() {
        return this.ioId;
    }

    private void setIoId(Element element) {
        Node input = element.getElementsByTagName("input").item(0);
        if (input != null) {
            this.ioId = input.getTextContent();
        }
    }

    public String getSource() {
        String attr = this.getAttribute("source");
        return attr == null || attr.isEmpty() || "(null)".equals(attr) ? null : attr;
    }

    public String getTarget() {
        String attr = this.getAttribute("target");
        return attr == null || attr.isEmpty() || "(null)".equals(attr) ? null : attr;
    }

    @Override
    public String getUmlLabel() {
        return this.getParent().getUmlLabel();
    }

    @Override
    public boolean hasErrors() {
        return this.getParent().hasErrors() || super.hasErrors();
    }
}

