/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.request;

import ch.e2e.builder.trace.testcase.TestcaseParameter;
import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterContainer;
import ch.e2e.builder.trace.testcase.parameter.ParameterDefinitionHolder;
import ch.e2e.builder.trace.testcase.parameter.ParameterFactory;
import ch.e2e.builder.trace.tools.NamespacesManager;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RequestTemplate
implements ParameterDefinitionHolder {
    private String name;
    private String namespace;
    private String prefix;
    protected List<TestcaseParameter> parameters = new ArrayList<TestcaseParameter>();
    protected List<String> names = new ArrayList<String>();
    private NamespacesManager namespacesManager;

    public RequestTemplate(File home, Element requestElement, Element namespacesElement, boolean rpcEncoded) {
        this.namespacesManager = new NamespacesManager(home, namespacesElement);
        this.initialize(home, requestElement, this, rpcEncoded);
    }

    public RequestTemplate(File home, Element requestElement, RequestTemplate requestTemplate, boolean rpcEncoded) {
        this.namespacesManager = requestTemplate.getNamespacesManager();
        this.initialize(home, requestElement, requestTemplate, rpcEncoded);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public NamespacesManager getNamespacesManager() {
        return this.namespacesManager;
    }

    public Document createEmptyRequest() {
        Document document = DomUtilities.newDocument((String)"Request");
        Element root = document.getDocumentElement();
        root.setAttribute("name", this.name);
        root.setAttribute("namespace", this.namespace);
        root.setAttribute("prefix", this.prefix);
        Element parameterElement = document.createElement("Parameter");
        for (TestcaseParameter testcaseParameter : this.parameters) {
            parameterElement.appendChild(testcaseParameter.createEmptyParameter(document));
        }
        root.appendChild(parameterElement);
        return document;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Parameter findDefinition(String[] path) {
        ParameterContainer container = this;
        for (int i = 0; i < path.length - 1; ++i) {
            container = (ParameterContainer)((Object)container.getParameter(path[i]));
        }
        return container.getParameter(path[path.length - 1]);
    }

    @Override
    public Parameter getParameter(String name) {
        int index = this.names.indexOf(name);
        return index == -1 ? null : (Parameter)this.parameters.get(index);
    }

    public void update(RequestTemplate template, boolean rpcEncoded) {
        if (rpcEncoded) {
            this.name = template.name;
            this.namespace = template.namespace;
            this.prefix = template.prefix;
        }
    }

    protected void initialize(File home, Element requestElement, RequestTemplate requestTemplate, boolean rpcEncoded) {
        this.namespacesManager = requestTemplate.namespacesManager;
        if (requestElement != null && rpcEncoded) {
            this.name = requestElement.getAttribute("name");
            this.namespace = requestElement.getAttribute("namespace");
            this.prefix = this.namespacesManager.getPrefix(this.namespace);
            NodeList parameterList = requestElement.getElementsByTagName("Parameter");
            if (parameterList != null && parameterList.getLength() == 1) {
                ParameterFactory.createParameter(parameterList.item(0).getChildNodes(), this.parameters, this.names, false, null, requestTemplate);
            }
            if (home != null) {
                this.namespacesManager.save(home);
            }
        }
    }
}

