/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.request;

import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.AdapterOutputContainer;
import ch.e2e.builder.trace.testcase.AdapterOutputContainerList;
import ch.e2e.builder.trace.testcase.SynchronousTestcaseTemplate;
import ch.e2e.builder.trace.testcase.TestcaseParameter;
import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterFactory;
import ch.e2e.builder.trace.testcase.parameter.RecordParameter;
import ch.e2e.builder.trace.testcase.request.Logging;
import ch.e2e.builder.trace.testcase.request.RequestTemplate;
import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.TypeMapper;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import ch.e2e.swing.TreeObject;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Request
extends RequestTemplate
implements TreeObject,
Logging {
    private final boolean rpcEncoded;
    private boolean hasErrors = false;
    private File requestFile;
    private File adapterOutputsFile;
    private String docEncRequest;
    private boolean changed = false;
    private AdapterOutputContainerList adapterOutputContainers;

    public Request(File requestFile, File adapterOutputsFile, RequestTemplate requestTemplate, boolean rpcEncoded) throws IOException, ParserConfigurationException, SAXException {
        super(requestFile.getParentFile(), rpcEncoded ? DomUtilities.parse((File)requestFile, (boolean)false, (boolean)false).getDocumentElement() : null, requestTemplate, rpcEncoded);
        this.requestFile = requestFile;
        this.adapterOutputsFile = adapterOutputsFile;
        this.rpcEncoded = rpcEncoded;
        if (!rpcEncoded) {
            try {
                this.docEncRequest = DomUtilities.asString((Node)DomUtilities.parse((File)requestFile, (boolean)false, (boolean)false, (boolean)false));
            }
            catch (SAXParseException e) {
                logger.warning("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                StringWriter out = new StringWriter();
                FileUtilities.copy((Reader)new FileReader(requestFile), (Writer)out);
                this.docEncRequest = out.toString();
            }
        }
    }

    public void fillRequestRoot(Element root, AbstractSynchronousTestcase testcase) {
        Element body = this.createRequestBody(root, testcase);
        body.appendChild(this.createSOAPRequest(root.getOwnerDocument()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document createRequestDocument(AbstractSynchronousTestcase testcase) {
        Document document = null;
        String soapEnvelopeNamespaceUri = testcase.getTemplate().getSoapEnvelopeNamespaceUri();
        if (testcase.isRPCEncoding()) {
            document = DomUtilities.newDocument((String)soapEnvelopeNamespaceUri, (String)"env:Envelope");
            this.fillRequestRoot(document.getDocumentElement(), testcase);
        } else {
            try (StringReader reader = new StringReader(this.docEncRequest);){
                document = DomUtilities.parse((Reader)reader, (boolean)false, (boolean)false, (boolean)true);
                Element root = document.getDocumentElement();
                Element header = (Element)root.getElementsByTagNameNS(soapEnvelopeNamespaceUri, "Header").item(0);
                if (header == null) {
                    root.insertBefore(this.createSOAPHeader(document, testcase), root.getFirstChild());
                } else {
                    header.insertBefore(testcase.getTraceSettings().createTraceElement(document), header.getFirstChild());
                    Element mockBackendsElement = this.createMockBackendsElement(document, testcase);
                    if (mockBackendsElement != null) {
                        this.setRootAttributes(header, this.getNamespaces(), testcase);
                        header.appendChild(mockBackendsElement);
                    }
                }
            }
        }
        return document;
    }

    public void fillDocumentEncodedRequestRoot(Element root, AbstractSynchronousTestcase testcase) {
        StringReader reader = new StringReader(this.docEncRequest);
        try {
            Document document = DomUtilities.parse((Reader)reader, (boolean)false, (boolean)false);
            Element header = this.createSOAPHeader(root.getOwnerDocument(), testcase);
            NodeList headerElements = (NodeList)DomUtilities.evaluate((Node)document.getDocumentElement(), (String)"env:Header/*", (QName)XPathConstants.NODESET);
            int length = headerElements.getLength();
            for (int i = 0; i < length; ++i) {
                header.appendChild(root.getOwnerDocument().importNode(headerElements.item(i), true));
            }
            NamedNodeMap attributes = header.getAttributes();
            length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                header.setAttributeNode((Attr)attributes.item(i));
            }
            root.appendChild(header);
            Node body = root.getOwnerDocument().importNode(document.getDocumentElement().getFirstChild(), true);
            root.appendChild(body);
        }
        catch (Exception e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "fillDocumentEncodedRequestRoot", e);
        }
    }

    public void fillRequestRoot(Element root, AbstractSynchronousTestcase testcase, TraceContainer traceContainer) {
        Element body = this.createRequestBody(root, testcase);
        Element request = this.createSOAPRequest(root.getOwnerDocument());
        NodeList children = request.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            TypeMapper.mapTypes((Element)child, traceContainer.getNamespaceContext());
            traceContainer.addIOEntry((Element)child, "REQUEST");
        }
        body.appendChild(request);
    }

    public void reload(Element requestElement, RequestTemplate template) {
        this.hasErrors = false;
        if (this.rpcEncoded) {
            this.names.clear();
            this.parameters.clear();
            this.initialize(this.getRequestFile().getParentFile(), requestElement, template, true);
        } else {
            this.docEncRequest = DomUtilities.asString((Node)requestElement);
        }
    }

    public void reload(String request) {
        if (this.rpcEncoded) {
            throw new UnsupportedOperationException();
        }
        this.docEncRequest = request;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public void setHasErrors(boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    private Element createRequestBody(Element root, AbstractSynchronousTestcase testcase) {
        this.setRootAttributes(root, this.getNamespaces(), testcase);
        root.appendChild(this.createSOAPHeader(root.getOwnerDocument(), testcase));
        Element body = root.getOwnerDocument().createElementNS(testcase.getTemplate().getSoapEnvelopeNamespaceUri(), "env:Body");
        root.appendChild(body);
        return body;
    }

    private Element createSOAPHeader(Document document, AbstractSynchronousTestcase testcase) {
        String soapEnvelopeNamespaceUri = testcase.getTemplate().getSoapEnvelopeNamespaceUri();
        String prefix = document.lookupPrefix(soapEnvelopeNamespaceUri);
        if (prefix == null) {
            prefix = this.getNamespacesManager().getPrefix(soapEnvelopeNamespaceUri);
        }
        Element soapHeader = document.createElementNS(soapEnvelopeNamespaceUri, prefix + ":" + "Header");
        soapHeader.appendChild(testcase.getTraceSettings().createTraceElement(document));
        Element mockBackendsElement = this.createMockBackendsElement(document, testcase);
        if (mockBackendsElement != null) {
            soapHeader.appendChild(mockBackendsElement);
            this.setRootAttributes(soapHeader, this.getNamespaces(), testcase);
        }
        return soapHeader;
    }

    private Element createMockBackendsElement(Document document, AbstractSynchronousTestcase testcase) {
        Node element = null;
        if (this.adapterOutputsFile.exists()) {
            this.adapterOutputContainers = new AdapterOutputContainerList(testcase);
            Iterator iterator = this.adapterOutputContainers.iterator();
            while (iterator.hasNext()) {
                DocumentFragment adapterOutputElements;
                AdapterOutputContainer adapterOutputContainer = (AdapterOutputContainer)iterator.next();
                if (!adapterOutputContainer.isUse() || (adapterOutputElements = adapterOutputContainer.createAdapterOutputSoapElements(document)) == null) continue;
                if (element == null) {
                    element = document.createElementNS("http://e2e.ch/bridge", "bridge:Mock");
                }
                element.appendChild(adapterOutputElements);
            }
        }
        return element;
    }

    private void setRootAttributes(Element root, Collection<String> namespaces, AbstractSynchronousTestcase testcase) {
        SynchronousTestcaseTemplate template = testcase.getTemplate();
        String soapEnvelopeNamespaceUri = template.getSoapEnvelopeNamespaceUri();
        String soapEncodingNamespaceUri = template.getSoapEncodingNamespaceUri();
        root.setAttribute(this.getNamespacesManager().getXmlnsPrefix("http://www.w3.org/2001/XMLSchema"), "http://www.w3.org/2001/XMLSchema");
        root.setAttribute(this.getNamespacesManager().getXmlnsPrefix("http://www.w3.org/2001/XMLSchema-instance"), "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute(this.getNamespacesManager().getXmlnsPrefix(soapEnvelopeNamespaceUri), soapEnvelopeNamespaceUri);
        root.setAttribute(this.getNamespacesManager().getXmlnsPrefix(soapEncodingNamespaceUri), soapEncodingNamespaceUri);
        root.setAttribute(this.getNamespacesManager().getXmlnsPrefix("http://e2e.ch/bridge"), "http://e2e.ch/bridge");
        root.setAttribute(this.getNamespacesManager().getPrefix(soapEnvelopeNamespaceUri) + ":" + "encodingStyle", soapEncodingNamespaceUri);
        for (String namespace : namespaces) {
            root.setAttribute(this.getNamespacesManager().getXmlnsPrefix(namespace), namespace);
        }
    }

    private Element createSOAPRequest(Document document) {
        Element request = document.createElementNS(this.getNamespace(), this.getPrefix() + ':' + this.getName());
        ParameterFactory.appendSOAPChilds(this.parameters, request, document);
        return request;
    }

    public Object getChild(int index) {
        return this.parameters.get(index);
    }

    public int getChildCount() {
        return this.parameters.size();
    }

    public int getIndexOfChild(Object child) {
        return this.parameters.indexOf(child);
    }

    public boolean isLeaf() {
        return this.parameters.size() == 0;
    }

    public int getType() {
        return -1;
    }

    public Collection<String> getNamespaces() {
        HashSet<String> namespaces = new HashSet<String>();
        String namespace = this.getNamespace();
        if (namespace != null) {
            namespaces.add(namespace);
        }
        for (TestcaseParameter testcaseParameter : this.parameters) {
            if (!(testcaseParameter instanceof RecordParameter)) continue;
            namespaces.addAll(((RecordParameter)testcaseParameter).getNamespaces());
        }
        if (this.adapterOutputContainers != null) {
            Iterator iterator = this.adapterOutputContainers.iterator();
            while (iterator.hasNext()) {
                AdapterOutputContainer container = (AdapterOutputContainer)iterator.next();
                if (!container.isUse()) continue;
                namespaces.addAll(container.getNamespaces());
            }
        }
        return Collections.unmodifiableCollection(namespaces);
    }

    public String getRequest() throws IOException {
        return this.rpcEncoded ? DomUtilities.asString((Node)this.createRequestDocument()) : this.docEncRequest;
    }

    public File getRequestFile() {
        return this.requestFile;
    }

    public void setRequestFile(File requestFile) {
        this.requestFile = requestFile;
    }

    public void setAdapterOutputsFile(File adapterOutputsFile) {
        this.adapterOutputsFile = adapterOutputsFile;
    }

    public void save() throws IOException, TransformerException, SAXException, ParserConfigurationException {
        this.save(false);
    }

    public void save(boolean forced) throws IOException, TransformerException, SAXException, ParserConfigurationException {
        if (forced || this.isChanged()) {
            DomUtilities.serialize((File)this.requestFile, (Document)(this.rpcEncoded ? this.createRequestDocument() : DomUtilities.parse((Reader)new StringReader(this.docEncRequest), (boolean)false, (boolean)false)), (boolean)true);
        }
    }

    public boolean isChanged() {
        if (this.rpcEncoded) {
            this.changed = false;
            int size = this.parameters.size();
            for (int i = 0; i < size && !this.changed; ++i) {
                this.changed = ((Parameter)this.parameters.get(i)).isChanged();
            }
        }
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public Document createRequestDocument() {
        Document document = DomUtilities.newDocument((String)"Request");
        Element root = document.getDocumentElement();
        root.setAttribute("name", this.getName());
        root.setAttribute("prefix", this.getPrefix());
        root.setAttribute("namespace", this.getNamespace());
        Element parameterElement = document.createElement("Parameter");
        for (TestcaseParameter parameter : this.parameters) {
            parameterElement.appendChild(((Parameter)parameter).createParameterElement(document));
        }
        root.appendChild(parameterElement);
        return document;
    }
}

