/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.parameter;

import ch.e2e.builder.trace.testcase.parameter.NativeTypeParameter;
import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterDefinitionHolder;
import ch.e2e.builder.trace.testcase.parameter.RecordParameter;
import org.w3c.dom.Element;

public class IntegerParameter
extends NativeTypeParameter {
    public IntegerParameter(Element parameterElement, boolean arrayItem, int type, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        this(parameterElement, type, arrayItem, parent, definitionHolder, false);
    }

    public IntegerParameter(Element parameterElement, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder, boolean namespaceAware) {
        super(parameterElement, type, arrayItem, parent, definitionHolder, namespaceAware);
    }

    private IntegerParameter(String name, boolean arrayItem, int type, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        super(name, type, arrayItem, parent, definitionHolder);
        this.setValue(new Integer(0));
    }

    @Override
    public IntegerParameter copy(RecordParameter parent) {
        IntegerParameter result = new IntegerParameter(this.getName(), this.isArrayItem(), this.getType(), parent, this.getDefinitionHolder());
        result.setValue(this.getValue());
        return result;
    }

    @Override
    public String getDiagramName() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "Base Types.Integer";
    }

    @Override
    public boolean importValue(Object value) {
        boolean imported = false;
        if (value == null) {
            this.setValue(value);
            imported = true;
        } else {
            try {
                this.setValue(Integer.parseInt(value.toString()));
                imported = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return imported;
    }

    @Override
    Object createValue(Element parameterElement) {
        Integer result;
        if (parameterElement.hasChildNodes()) {
            try {
                result = Integer.valueOf(parameterElement.getFirstChild().getNodeValue());
            }
            catch (NumberFormatException e) {
                result = 0;
            }
        } else {
            result = 0;
        }
        return result;
    }

    @Override
    public Parameter createEmptyParameter(RecordParameter parent) {
        return new IntegerParameter(this.getName(), this.isArrayItem(), this.getType(), parent, this.getDefinitionHolder());
    }
}

