/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase;

import ch.e2e.builder.base.message.SendWarningEvent;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.Logging;
import ch.e2e.builder.trace.testcase.SynchronousTestcaseTemplate;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestcaseMerger {
    private static XPath xPath = DomUtilities.newXPath();

    private TestcaseMerger() {
    }

    public static void merge(SynchronousTestcaseTemplate template, AbstractSynchronousTestcase testcase) {
        testcase.setTemplate(template);
        testcase.saveRequest(true);
        File requestFile = testcase.getRequestFile();
        if (requestFile.exists()) {
            try {
                Element testcaseElement = TestcaseMerger.getTestcaseElement(testcase);
                boolean changed = TestcaseMerger.mergeElement(TestcaseMerger.getTemplateElement(template), testcaseElement, template.isRPCEncoding());
                if (changed) {
                    DomUtilities.removeAllNotElementEmptyNodes((Element)testcaseElement);
                    DomUtilities.serialize((File)requestFile, (Document)testcaseElement.getOwnerDocument(), (boolean)true);
                    testcase.clearResult();
                    testcase.saveProperties();
                    testcase.getRequest().reload(testcaseElement, template.getRequestTemplate());
                }
            }
            catch (Exception e) {
                Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                Logging.logger.throwing(TestcaseMerger.class.getName(), "merge", e);
                String msg = "Failed to merge testcase '" + template.getFullQualifiedName() + "." + testcase.getName() + "' (Reason: " + e.getLocalizedMessage() + ").";
                EventController.fire((EventObject)new SendWarningEvent(TestcaseMerger.class, msg, null, "tracer", "Trace Analyzer Messages"));
            }
        }
    }

    private static Element getTemplateElement(SynchronousTestcaseTemplate template) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        Element e = DomUtilities.parse((File)template.getTemplateFile(), (boolean)false, (boolean)false).getDocumentElement();
        String expression = template.isRPCEncoding() ? "Request" : "Request/*";
        return (Element)xPath.evaluate(expression, e, XPathConstants.NODE);
    }

    private static Element getTestcaseElement(AbstractSynchronousTestcase testcase) throws IOException, ParserConfigurationException, SAXException {
        Document d = DomUtilities.parse((File)testcase.getRequestFile(), (boolean)false, (boolean)false);
        return d.getDocumentElement();
    }

    private static boolean mergeElement(Element templateElement, Element testcaseElement, boolean rpcEncoding) {
        boolean changed = false;
        Map<String, Element> templateChildren = TestcaseMerger.getChildElements(templateElement);
        Map<String, Element> testcaseChildren = TestcaseMerger.getChildElements(testcaseElement);
        for (String key : templateChildren.keySet()) {
            Document document;
            Element templateChild = templateChildren.get(key);
            Element testcaseChild = testcaseChildren.get(key);
            if (testcaseChild == null) {
                document = testcaseElement.getOwnerDocument();
                testcaseElement.appendChild(document.importNode(templateChild, true));
                changed = true;
                continue;
            }
            if (rpcEncoding) {
                if (templateChild.getAttribute("type").equals(testcaseChild.getAttribute("type"))) {
                    String namespace = templateChild.getAttribute("namespace");
                    if (!namespace.equals(testcaseChild.getAttribute("namespace"))) {
                        testcaseChild.setAttribute("namespace", namespace);
                        changed = true;
                    }
                    changed |= TestcaseMerger.mergeElement(templateChild, testcaseChild, rpcEncoding);
                } else {
                    document = testcaseElement.getOwnerDocument();
                    testcaseElement.replaceChild(document.importNode(templateChild, true), testcaseChild);
                    changed = true;
                }
            } else {
                changed |= TestcaseMerger.mergeAttributes(templateChild, testcaseChild);
                changed |= TestcaseMerger.mergeElement(templateChild, testcaseChild, rpcEncoding);
            }
            testcaseChildren.remove(key);
        }
        for (Element toBeRemoved : testcaseChildren.values()) {
            toBeRemoved.getParentNode().removeChild(toBeRemoved);
            changed = true;
        }
        return changed;
    }

    private static boolean mergeAttributes(Element templateElement, Element testcaseElement) {
        boolean changed = false;
        Map<String, Node> testcaseAttributes = TestcaseMerger.getAttributes(testcaseElement);
        for (Map.Entry<String, Node> entry : TestcaseMerger.getAttributes(templateElement).entrySet()) {
            Node testcaseAttribute = testcaseAttributes.get(entry.getKey());
            if (testcaseAttribute == null) {
                testcaseElement.setAttribute(entry.getKey(), entry.getValue().getNodeValue());
                changed = true;
                continue;
            }
            testcaseAttributes.remove(entry.getKey());
        }
        for (String toBeRemoved : testcaseAttributes.keySet()) {
            testcaseElement.removeAttribute(toBeRemoved);
            changed = true;
        }
        return changed;
    }

    private static Map<String, Node> getAttributes(Element element) {
        TreeMap<String, Node> result = new TreeMap<String, Node>();
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Node attribute = attributes.item(i);
            result.put(attribute.getNodeName(), attribute);
        }
        return result;
    }

    private static Map<String, Element> getChildElements(Element element) {
        TreeMap<String, Element> result = new TreeMap<String, Element>();
        try {
            NodeList children = (NodeList)xPath.evaluate("./*[name()!=\"AdapterTemplates\"]", element, XPathConstants.NODESET);
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                Element child = (Element)children.item(i);
                result.put(child.getNodeName(), child);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return result;
    }
}

