/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase;

import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.io.FilesNotDeletedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

public class TestcaseContainer
extends TestcaseObject {
    private TreeMap<String, TestcaseObject> children = new TreeMap();
    private String name;
    private int type;

    public TestcaseContainer(String name, int type) {
        this.name = name;
        this.type = type;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean exists(String childName) {
        return this.children.containsKey(childName);
    }

    public void add(TestcaseObject child) {
        this.children.put(child.getName(), child);
        child.setParent(this);
    }

    public void delete(TestcaseObject child) throws FilesNotDeletedException {
        child.clear();
        this.children.remove(child.getName());
        child.delete();
    }

    @Override
    public Object getChild(int index) {
        TestcaseObject result;
        Iterator<TestcaseObject> children = this.children.values().iterator();
        int i = 0;
        do {
            result = children.next();
        } while (++i <= index);
        return result;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    @Override
    public int getIndexOfChild(Object child) {
        int result = -1;
        if (this.children.size() > 0) {
            Iterator<TestcaseObject> children = this.children.values().iterator();
            int index = -1;
            do {
                ++index;
                TestcaseObject nextChild = children.next();
                if (!((Object)nextChild).equals(child)) continue;
                result = index;
            } while (children.hasNext() && result == -1);
        }
        return result;
    }

    public TestcaseObject get(String name) {
        return this.children.get(name);
    }

    public TestcaseObject find(String path) {
        TestcaseContainer root = this;
        TestcaseObject found = null;
        String[] parts = path.split("\\.");
        int i = 0;
        for (String part : parts) {
            ++i;
            found = root.get(part);
            if (!(found instanceof TestcaseContainer)) break;
            root = (TestcaseContainer)found;
        }
        return i == parts.length ? found : null;
    }

    public TestcaseContainer getContainer(String name, boolean create, int type) {
        TestcaseContainer result = (TestcaseContainer)this.children.get(name);
        if (create && result == null) {
            result = new TestcaseContainer(name, type);
            this.add(result);
        }
        return result;
    }

    @Override
    public void clear() {
        for (TestcaseObject testcaseObject : this.children.values()) {
            testcaseObject.clear();
        }
        this.children.clear();
    }

    @Override
    protected void delete() throws FilesNotDeletedException {
    }

    public TreeMap<String, TestcaseObject> getChildren() {
        return this.children;
    }

    public ArrayList<Testcase> getAllTestcases() {
        ArrayList<Testcase> result = new ArrayList<Testcase>();
        for (TestcaseObject testcaseObject : this.children.values()) {
            if (testcaseObject instanceof Testcase) {
                result.add((Testcase)testcaseObject);
                continue;
            }
            if (!(testcaseObject instanceof TestcaseContainer)) continue;
            result.addAll(((TestcaseContainer)testcaseObject).getAllTestcases());
        }
        return result;
    }

    public boolean hasExecutedTestcases() {
        boolean result = this instanceof Testcase && ((Testcase)this).getStatus() != 7;
        ArrayList<Testcase> allTestcases = this.getAllTestcases();
        int length = allTestcases.size();
        for (int i = 0; i < length && !result; ++i) {
            result = allTestcases.get(i).getStatus() != 7;
        }
        return result;
    }
}

