/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase;

import ch.e2e.builder.trace.testcase.AdapterOutput;
import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterContainer;
import ch.e2e.builder.trace.testcase.parameter.ParameterDefinitionHolder;
import ch.e2e.builder.trace.testcase.parameter.ParameterFactory;
import ch.e2e.builder.trace.tools.NamespacesManager;
import ch.e2e.dom.DomUtilities;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdapterTemplate
implements ParameterDefinitionHolder {
    private String id;
    private String name;
    private String packageName;
    private String adapterType;
    private String adapterName;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<String> parameterNames = new ArrayList<String>();
    private NamespacesManager namespacesManager;

    public AdapterTemplate(Element element, NamespacesManager namespacesManager) {
        this.namespacesManager = namespacesManager;
        this.id = element.getAttribute("id");
        this.name = element.getAttribute("name");
        this.packageName = element.getAttribute("package");
        try {
            Element adapterElement = (Element)DomUtilities.selectNode((Node)element, (String)"*");
            this.adapterType = adapterElement.getNodeName();
            this.adapterName = adapterElement.getAttribute("name");
            NodeList parameterNodes = (NodeList)DomUtilities.evaluate((Node)adapterElement, (String)"*", (QName)XPathConstants.NODESET);
            ParameterFactory.createParameter(parameterNodes, this.parameters, this.parameterNames, false, null, this);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public String getAdapterType() {
        return this.adapterType;
    }

    public String getAdapterName() {
        return this.adapterName;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public Parameter findDefinition(String[] path) {
        ParameterContainer container = this;
        for (int i = 0; i < path.length - 1; ++i) {
            container = (ParameterContainer)((Object)container.getParameter(path[i]));
        }
        return container.getParameter(path[path.length - 1]);
    }

    @Override
    public NamespacesManager getNamespacesManager() {
        return this.namespacesManager;
    }

    @Override
    public Parameter getParameter(String name) {
        int index = this.parameterNames.indexOf(name);
        return this.parameters.get(index);
    }

    public AdapterOutput createAdapterOutput() {
        return new AdapterOutput(this);
    }

    public String toString() {
        return this.name + " [" + this.packageName + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof AdapterTemplate && this.id.equals(((AdapterTemplate)obj).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

