/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase;

import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.AdapterOutput;
import ch.e2e.builder.trace.testcase.AdapterTemplate;
import ch.e2e.builder.trace.testcase.AdapterTemplateInfo;
import ch.e2e.builder.trace.tools.NamespacesManager;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.ZipUtilities;
import ch.e2e.swing.TreeObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AdapterOutputContainer
implements TreeObject {
    public static final String ELEMENT_NAME = "Adapter";
    public static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_PACKAGE = "package";
    private static final String ATTRIBUTE_USE = "use";
    private AdapterTemplate adapterTemplate;
    private List<AdapterOutput> adapterOutputs;
    private boolean use = false;
    private boolean changed = false;
    private final AdapterTemplateInfo adapterInfo;
    private final File adapterTemplatesFile;
    private final NamespacesManager namespaceManager;

    public AdapterOutputContainer(AdapterTemplateInfo adapterInfo, AbstractSynchronousTestcase testcase, boolean readOutputsFile) throws IOException, SAXException, ParserConfigurationException {
        this.adapterInfo = adapterInfo;
        this.adapterTemplatesFile = new File(testcase.getAdapterInfoHome(), "adapter.templates.zip");
        this.namespaceManager = testcase.getRequest().getNamespacesManager();
        this.adapterOutputs = new ArrayList<AdapterOutput>();
        if (readOutputsFile) {
            this.readAdapterOutputs(testcase.getAdapterOutputsFile());
        }
    }

    private AdapterOutputContainer(AdapterOutputContainer adapterOutputContainer) {
        this.adapterInfo = adapterOutputContainer.adapterInfo;
        this.adapterTemplatesFile = adapterOutputContainer.adapterTemplatesFile;
        this.adapterTemplate = adapterOutputContainer.adapterTemplate;
        this.adapterOutputs = new ArrayList<AdapterOutput>(adapterOutputContainer.adapterOutputs.size());
        this.use = adapterOutputContainer.use;
        this.namespaceManager = adapterOutputContainer.namespaceManager;
        for (AdapterOutput adapterOutput : adapterOutputContainer.adapterOutputs) {
            this.addAdapterOutput(adapterOutput.copy());
        }
    }

    public AdapterOutputContainer copy() {
        return new AdapterOutputContainer(this);
    }

    public boolean isUse() {
        return this.use;
    }

    public void setUse(boolean use) {
        this.changed = this.use != use;
        this.use = use;
    }

    public boolean isChanged() {
        if (!this.changed) {
            for (AdapterOutput adapterOutput : this.adapterOutputs) {
                if (!adapterOutput.isChanged()) continue;
                return true;
            }
        }
        return this.changed;
    }

    public AdapterOutput addAdapterOutput() {
        return this.addAdapterOutput(this.getAdapterTemplate().createAdapterOutput());
    }

    public AdapterOutput addAdapterOutput(AdapterOutput adapterOutput) {
        boolean added = this.adapterOutputs.add(adapterOutput);
        if (added) {
            this.changed = true;
            adapterOutput.setContainer(this);
        }
        return added ? adapterOutput : null;
    }

    public AdapterOutput addAdapterOutput(int index, AdapterOutput adapterOutput) {
        adapterOutput.setContainer(this);
        this.adapterOutputs.add(index, adapterOutput);
        this.changed = true;
        return adapterOutput;
    }

    public AdapterOutput removeAdapterOutput(AdapterOutput adapterOutput) {
        boolean removed = this.adapterOutputs.remove(adapterOutput);
        if (removed) {
            this.changed = true;
            adapterOutput.setContainer(null);
            if (this.adapterOutputs.isEmpty()) {
                this.use = false;
            }
        }
        return removed ? adapterOutput : null;
    }

    public void clear() {
        for (AdapterOutput adapterOutput : this.adapterOutputs) {
            adapterOutput.setContainer(null);
        }
        this.adapterOutputs.clear();
        this.changed = true;
        this.use = false;
    }

    public AdapterOutput copyAndAddAdapterOutput(AdapterOutput adapterOutput) {
        int index = this.getIndexOfChild(adapterOutput);
        return this.addAdapterOutput(index + 1, new AdapterOutput(adapterOutput));
    }

    public String getId() {
        return this.adapterInfo.getId();
    }

    public String getName() {
        return this.adapterInfo.getName();
    }

    public String getPackageName() {
        return this.adapterInfo.getPackage();
    }

    public String getAdapterName() {
        return this.getAdapterTemplate().getAdapterName();
    }

    public String getAdapterType() {
        return this.adapterInfo.getType();
    }

    public AdapterTemplate getAdapterTemplate() {
        if (this.adapterTemplate == null) {
            try {
                Document templateDoc = ZipUtilities.getZippedDocumentFromFile((File)this.adapterTemplatesFile, (String)this.adapterInfo.getFileId(), (boolean)false, (boolean)false);
                this.adapterTemplate = new AdapterTemplate(templateDoc.getDocumentElement(), this.namespaceManager);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.adapterTemplate;
    }

    public Collection<String> getNamespaces() {
        HashSet<String> namespaces = new HashSet<String>();
        for (AdapterOutput adapterOutput : this.adapterOutputs) {
            namespaces.addAll(adapterOutput.getNamespaces());
        }
        return Collections.unmodifiableCollection(namespaces);
    }

    public Element createAdapterOutputContainerElement(Document document) {
        Element element = null;
        if (!this.isEmpty()) {
            element = document.createElement(ELEMENT_NAME);
            element.setAttribute(ATTRIBUTE_ID, this.getId());
            element.setAttribute(ATTRIBUTE_NAME, this.getName());
            element.setAttribute(ATTRIBUTE_PACKAGE, this.getPackageName());
            element.setAttribute(ATTRIBUTE_USE, String.valueOf(this.use));
            element.appendChild(this.createAdapterOutputElements(document));
        }
        return element;
    }

    public boolean isEmpty() {
        return this.adapterTemplate == null || this.adapterOutputs.isEmpty();
    }

    public DocumentFragment createAdapterOutputElements(Document document) {
        DocumentFragment fragment = document.createDocumentFragment();
        for (AdapterOutput adapterOutput : this.adapterOutputs) {
            fragment.appendChild(adapterOutput.createAdapterOutputElement(document));
        }
        return fragment;
    }

    public DocumentFragment createAdapterOutputSoapElements(Document document) {
        DocumentFragment fragment = null;
        if (!this.adapterOutputs.isEmpty()) {
            fragment = document.createDocumentFragment();
            for (AdapterOutput adapterOutput : this.adapterOutputs) {
                fragment.appendChild(adapterOutput.createAdapterOutputSoapElement(document));
            }
        }
        return fragment;
    }

    private void parse(Element element) {
        try {
            this.use = DomUtilities.getBoolean((Element)element, (String)ATTRIBUTE_USE, (boolean)false);
            NodeList nodes = (NodeList)DomUtilities.evaluate((Node)element, (String)"*", (QName)XPathConstants.NODESET);
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                this.addAdapterOutput(new AdapterOutput((Element)nodes.item(i), this.getAdapterTemplate()));
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public Object getChild(int index) {
        return this.adapterOutputs.get(index);
    }

    public int getChildCount() {
        return this.adapterOutputs.size();
    }

    public int getIndexOfChild(Object child) {
        return this.adapterOutputs.indexOf(child);
    }

    public boolean isLeaf() {
        return this.adapterOutputs.isEmpty();
    }

    public int getType() {
        return 0;
    }

    public String toString() {
        return this.adapterInfo.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof AdapterOutputContainer && this.getId().equals(((AdapterOutputContainer)obj).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean differsFrom(AdapterOutputContainer other) {
        int childCount = this.getChildCount();
        boolean differs = this.use != other.use || childCount != other.getChildCount();
        for (int i = 0; !differs && i < childCount; ++i) {
            differs = this.adapterOutputs.get(i).differsFrom(other.adapterOutputs.get(i));
        }
        return differs;
    }

    private void readAdapterOutputs(File adapterOutputsFile) throws ParserConfigurationException, SAXException, IOException {
        if (adapterOutputsFile.canRead()) {
            Element root = DomUtilities.parse((Reader)new InputStreamReader((InputStream)new FileInputStream(adapterOutputsFile), "UTF-8"), (boolean)false, (boolean)false, (boolean)false).getDocumentElement();
            NodeList adapterOutputContainerElements = root.getElementsByTagName(ELEMENT_NAME);
            int length = adapterOutputContainerElements.getLength();
            for (int i = 0; i < length; ++i) {
                Element element = (Element)adapterOutputContainerElements.item(i);
                String id = element.getAttribute(ATTRIBUTE_ID);
                if (!id.equals(this.adapterInfo.getId())) continue;
                this.parse(element);
            }
        }
    }
}

