/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.request;

import ch.e2e.builder.base.message.SendErrorEvent;
import ch.e2e.builder.trace.request.SOAPResponse;
import ch.e2e.builder.trace.tools.NamespacesManager;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.util.StringTools;
import java.io.Reader;
import java.io.StringReader;
import java.util.EventObject;
import org.w3c.dom.Document;

public class SOAPFault
extends SOAPResponse {
    private String message;

    public SOAPFault(String code, String message, NamespacesManager namespacesManager) {
        super(SOAPFault.createSOAPFaultNode(code, message, namespacesManager), null);
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    private static String createSOAPFaultString(String code, String msg, NamespacesManager namespacesManager) {
        String enc;
        String env;
        msg = StringTools.replaceXMLEntities((String)msg);
        if (namespacesManager == null) {
            env = "xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\"";
            enc = "env:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"";
        } else {
            String soapEnvelopeNamespaceUri = namespacesManager.getSoapEnvelopeNamespaceUri();
            String soapEncodingNamespaceUri = namespacesManager.getSoapEncodingNamespaceUri();
            String soapEnvelopeNamespacePrefix = namespacesManager.getPrefix(soapEnvelopeNamespaceUri);
            String soapEncodingNamespacePrefix = namespacesManager.getPrefix(soapEncodingNamespaceUri);
            env = "xmlns:" + soapEnvelopeNamespacePrefix + "=\"" + soapEnvelopeNamespaceUri + "\"";
            enc = soapEnvelopeNamespacePrefix + ":" + soapEncodingNamespacePrefix + "=\"" + soapEncodingNamespaceUri + "\"";
        }
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<env:Envelope " + env + " " + enc + ">\n\t<env:Body>\n\t\t<env:Fault type=\"SOAPResponse\">\n\t\t\t<faultcode type=\"Base Types.String\">Client</faultcode>\n\t\t\t<faultstring type=\"Base Types.String\">Client error</faultstring>\n\t\t\t<detail>\n\t\t\t\t<message>\n\t\t\t\t\t<category type=\"Base Types.String\">1</category>\n\t\t\t\t\t<domain type=\"Base Types.String\">E2EBuilder Model Tracer</domain>\n\t\t\t\t\t<code type=\"Base Types.String\">" + code + "</code>\n\t\t\t\t\t<description type=\"Base Types.String\">" + msg + "</description>\n\t\t\t\t</message>\n\t\t\t</detail>\n\t\t</env:Fault>\n\t</env:Body>\n</env:Envelope>\n";
    }

    public static Document createSOAPFaultNode(String code, String msg, NamespacesManager namespacesManager) {
        Document result = null;
        try {
            result = DomUtilities.parse((Reader)new StringReader(SOAPFault.createSOAPFaultString(code, msg, namespacesManager)), (boolean)false, (boolean)false, (boolean)true);
        }
        catch (Exception e) {
            EventController.fire((EventObject)new SendErrorEvent((Object)code, e.toString()));
        }
        return result;
    }
}

