/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.execute;

import ch.e2e.builder.trace.execute.SynchronousTestcaseRequest;
import ch.e2e.builder.trace.execute.TestcaseRequest;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import java.util.Date;
import java.util.HashMap;

public class RequestPool {
    private static RequestPool pool = new RequestPool();
    private HashMap<String, TestcaseRequest> requests = new HashMap();

    private RequestPool() {
    }

    public static RequestPool getInstance() {
        return pool;
    }

    public SynchronousTestcaseRequest createRequest(AbstractSynchronousTestcase testcase) {
        String name = testcase.getName();
        String requestId = name + '_' + new Date().getTime();
        SynchronousTestcaseRequest request = new SynchronousTestcaseRequest(testcase, requestId);
        this.requests.put(requestId, request);
        return request;
    }

    public TestcaseRequest getRequest(String id) {
        return this.requests.get(id);
    }

    public void removeRequest(String id) {
        this.requests.remove(id);
    }
}

