/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.importer;

import ch.e2e.builder.analyzer.Analyzer;
import ch.e2e.builder.analyzer.gui.ImportNameSelection;
import ch.e2e.builder.analyzer.importer.Logging;
import ch.e2e.builder.analyzer.model.TransactionLogObject;
import ch.e2e.builder.analyzer.model.TransactionLogsRoot;
import ch.e2e.builder.analyzer.tree.RefreshTransactionLogsTreeEvent;
import ch.e2e.builder.base.gui.E2EBuilderQuestionDialog;
import ch.e2e.builder.base.io.E2EFileFilter;
import ch.e2e.builder.base.io.FileService;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecutionVetoException;
import ch.e2e.util.StringTools;
import java.io.File;
import java.util.EventObject;

public class TransactionLogImporter
implements EventExecuter,
Logging {
    private static final String TRANSLATION_PREFIX = "transactionLog";
    private static final String PROPERTY_TRANSACTION_LOG = "transactionLog";
    private final TransactionLogsRoot root;
    private final Analyzer analyzer;

    public TransactionLogImporter(TransactionLogsRoot root, Analyzer analyzer) {
        this.root = root;
        this.analyzer = analyzer;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void execute(EventObject event) throws EventExecutionVetoException {
        File logFile = this.selectFile();
        if (logFile != null) {
            this.setLastImportPath(logFile);
            this.importFile(logFile);
        }
    }

    private void importFile(File file) {
        String name = file.getName();
        int idx = name.indexOf(46);
        if (idx > -1) {
            name = name.substring(0, idx);
        }
        if (this.startImport(name = ImportNameSelection.getNewName(name, this.root.getTransactionLogNames(), this.analyzer, "transactionLog"))) {
            this.root.addTransactionLog(name, file);
            EventController.fire((EventObject)new RefreshTransactionLogsTreeEvent(this, (TransactionLogObject)this.root));
        }
    }

    private boolean startImport(String name) {
        return name != null && (!this.transactionLogExists(name) || this.overwriteQuestion(name));
    }

    private File selectFile() {
        return FileService.selectFile((File)this.getLastImportPath(), (E2EFileFilter[])new E2EFileFilter[]{new TransactionLogFileFilter()}, (String)this.getFileSelectorTitle(), (String)this.getFileSelectorSubtitle());
    }

    private boolean transactionLogExists(String transactionLogName) {
        return this.root.get(transactionLogName) != null;
    }

    private boolean overwriteQuestion(String transactionLogName) {
        String title = this.getAnalyzer().getTranslation("transactionLog.import.overwrite.question.title");
        String subtitle = this.getAnalyzer().getTranslation("transactionLog.import.overwrite.question.subtitle");
        String message = this.getAnalyzer().getTranslation("transactionLog.import.overwrite.question.message");
        title = StringTools.replaceProperty((String)title, (String)"transactionLog", (String)transactionLogName);
        boolean addTrace = E2EBuilderQuestionDialog.doYesNoQuestion((String)title, (String)subtitle, (String)message);
        return addTrace;
    }

    private File getLastImportPath() {
        return this.getAnalyzer().getLastTransactionLogFileImportPath();
    }

    private void setLastImportPath(File file) {
        this.getAnalyzer().setLastTransactionLogFileImportPath(file.getParentFile());
    }

    private String getFileSelectorTitle() {
        return this.getAnalyzer().getTranslation("transactionLog.file.selector.title");
    }

    private String getFileSelectorSubtitle() {
        return this.getAnalyzer().getTranslation("transactionLog.file.selector.subtitle");
    }

    private static class TransactionLogFileFilter
    extends E2EFileFilter {
        private static final String EXTENSION_LOG_ZIP = ".log.zip";
        private static final String EXTENSION_LOG = ".log";

        private TransactionLogFileFilter() {
        }

        public boolean accept(File f) {
            String path = f.getPath();
            return f.isDirectory() || path.endsWith(EXTENSION_LOG_ZIP) || path.endsWith(EXTENSION_LOG);
        }

        public String getDescription() {
            return ".log, .log.zip";
        }

        public String getDefaultExtension() {
            return null;
        }
    }
}

