/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.gui.uml;

import ch.e2e.builder.analyzer.gui.uml.ActivationBox;
import com.mxgraph.model.mxCell;
import com.mxgraph.view.mxGraph;
import java.util.ArrayList;

public class Lifeline
implements Comparable<Lifeline> {
    public static final String GROUP = "lifelineGroup ";
    public static final String OBJECT = "lifelineObject ";
    public static final String LINE = "lifeline ";
    private ArrayList<ActivationBox> activationBoxes = new ArrayList();
    protected String key;
    protected String name;
    protected Type type;
    private String style;

    public Lifeline(String key, String name, Type type, String style) {
        this.key = key;
        this.name = name;
        this.type = type;
        this.style = style;
    }

    public Lifeline(String key, String name, Type type) {
        this(key, name, type, "object");
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public void addActivationBox(ActivationBox activationBox) {
        this.activationBoxes.add(activationBox);
    }

    public mxCell createCell(mxGraph graph, int numberOfEntries) {
        mxCell lifeline = (mxCell)graph.insertVertex(null, GROUP + this.name, null, 0.0, 0.0, 0.0, 30.0 * (double)(numberOfEntries + 2), "group");
        mxCell objectCell = (mxCell)graph.insertVertex((Object)lifeline, OBJECT + this.name, (Object)this.name, 0.0, 0.0, 0.0, 0.0, this.style);
        graph.updateCellSize((Object)objectCell);
        mxCell sourcePort = (mxCell)graph.insertVertex((Object)objectCell, null, null, 0.5, 1.0, 0.0, 0.0);
        sourcePort.getGeometry().setRelative(true);
        mxCell targetPort = (mxCell)graph.insertVertex((Object)lifeline, null, null, objectCell.getGeometry().getCenterX(), lifeline.getGeometry().getY() + lifeline.getGeometry().getHeight(), 0.0, 0.0);
        graph.insertEdge((Object)lifeline, LINE + this.name, null, (Object)sourcePort, (Object)targetPort, "lifeline");
        for (ActivationBox box : this.activationBoxes) {
            mxCell targetCell = box.createCell(graph, lifeline);
            if (targetCell == null) continue;
            graph.translateCell((Object)targetCell, 0.5 * (objectCell.getGeometry().getWidth() - targetCell.getGeometry().getWidth()), 30.0 * (double)(box.getStartIndex() + 3));
        }
        return lifeline;
    }

    public void createEdges(mxGraph graph) {
        for (ActivationBox box : this.activationBoxes) {
            box.createEdges(graph);
        }
    }

    @Override
    public int compareTo(Lifeline o) {
        return this.getType().compareTo(o.getType());
    }

    public static enum Type {
        ACTOR,
        SERVICE,
        PSTATE,
        BACKEND;

    }
}

