/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.gui.tree;

import ch.e2e.builder.analyzer.Analyzer;
import ch.e2e.builder.analyzer.gui.tree.TransactionLogsTreeView;
import ch.e2e.builder.analyzer.gui.tree.TreeView;
import ch.e2e.builder.analyzer.model.TransactionLogsRoot;
import com.jidesoft.swing.JideTabbedPane;

public class TreeViewPane
extends JideTabbedPane {
    private static final String TRANSACTION_LOGS = "analyzer.overview.transactionLogs";
    private final Analyzer analyzer;

    public TreeViewPane(TransactionLogsRoot transactionLogsRoot, Analyzer analyzer) {
        super(2);
        this.analyzer = analyzer;
        this.addChangeListener(analyzer);
        this.createGui(transactionLogsRoot);
    }

    public TreeView getSelectedView() {
        return (TreeView)this.getSelectedComponent();
    }

    public void refresh(boolean deep) {
        int tabCount = this.getTabCount();
        for (int i = 0; deep && i < tabCount; ++i) {
            ((TreeView)this.getComponentAt(i)).getTree().refresh();
        }
        this.analyzer.getMainWindow().pathChanged(this.getSelectedView().getSelectionPath());
    }

    public void refresh() {
        this.refresh(true);
    }

    private void createGui(TransactionLogsRoot transactionLogsRoot) {
        this.addTab(this.analyzer.getTranslation(TRANSACTION_LOGS), new TransactionLogsTreeView(transactionLogsRoot, this.analyzer));
    }
}

